/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core;

import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;

public class CompletionProposal {
    public static final int GLOBAL_REF = 1;
    public static final int CONSTANT_REF = 2;
    public static final int KEYWORD = 3;
    public static final int INSTANCE_VARIABLE_REF = 4;
    public static final int LOCAL_VARIABLE_REF = 5;
    public static final int METHOD_REF = 6;
    public static final int METHOD_DECLARATION = 7;
    public static final int CLASS_VARIABLE_REF = 8;
    public static final int TYPE_REF = 9;
    public static final int VARIABLE_DECLARATION = 10;
    public static final int POTENTIAL_METHOD_DECLARATION = 11;
    public static final int METHOD_NAME_REFERENCE = 12;
    protected static final int FIRST_KIND = 1;
    protected static final int LAST_KIND = 12;
    private int completionKind;
    private int completionLocation;
    private int tokenStart = 0;
    private int tokenEnd = 0;
    private String completion = "";
    private int replaceStart = 0;
    private int replaceEnd = 0;
    private int relevance = 1;
    private String[] parameterNames = null;
    private boolean parameterNamesComputed = false;
    private String name = null;
    private int flags;
    private String type;
    private String declaringType;
    private IRubyElement element;
    private boolean blockNamesComputed;
    private String[] blockNames;

    public CompletionProposal(int kind, String completion, int relevance) {
        this.completionKind = kind;
        this.completion = completion;
        this.relevance = relevance;
    }

    public int getKind() {
        return this.completionKind;
    }

    public String getCompletion() {
        return this.completion;
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public int getCompletionLocation() {
        return this.completionLocation;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setReplaceRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.replaceStart = startIndex;
        this.replaceEnd = endIndex;
    }

    public String[] getParameterNames() {
        if (!this.parameterNamesComputed) {
            if (this.getElement() != null && this.getElement().isType(6)) {
                IMethod method = (IMethod)this.getElement();
                try {
                    this.parameterNames = method.getParameterNames();
                }
                catch (RubyModelException e) {
                    RubyCore.log((Exception)((Object)e));
                }
            }
            this.parameterNamesComputed = true;
        }
        return this.parameterNames;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        return "";
    }

    public String getDeclaringType() {
        if (this.declaringType != null) {
            return this.declaringType;
        }
        return "";
    }

    public void setType(String name) {
        this.type = name;
    }

    public void setDeclaringType(String elementName) {
        this.declaringType = elementName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setElement(IRubyElement element) {
        this.element = element;
    }

    public IRubyElement getElement() {
        return this.element;
    }

    public String[] getBlockVars() {
        if (!this.blockNamesComputed) {
            if (this.getElement().isType(6)) {
                IMethod method = (IMethod)this.getElement();
                try {
                    this.blockNames = method.getBlockParameters();
                }
                catch (RubyModelException e) {
                    RubyCore.log((Exception)((Object)e));
                }
            }
            this.blockNamesComputed = true;
        }
        return this.blockNames;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        if (this.element != null) {
            buffer.append(" (");
            buffer.append(this.element.toString());
            buffer.append(")");
        }
        return buffer.toString();
    }
}

