/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.parser.warnings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.AbstractVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.core.parser.DefaultProblem;
import org.rubypeople.rdt.internal.core.parser.Error;
import org.rubypeople.rdt.internal.core.parser.Warning;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RubyLintVisitor
extends AbstractVisitor {
    private String contents;
    protected Map<String, String> fOptions;
    private List<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();

    public RubyLintVisitor(String contents) {
        this(RubyCore.getOptions(), contents);
    }

    public RubyLintVisitor(Map<String, String> options, String contents) {
        this.contents = contents;
        this.fOptions = options;
    }

    protected String getSource(Node node) {
        return ASTUtil.getSource(this.contents, node);
    }

    protected String getSource(int start, int end) {
        if (this.contents.length() < end) {
            end = this.contents.length();
        }
        if (start < 0) {
            start = 0;
        }
        return this.contents.substring(start, end);
    }

    public List<CategorizedProblem> getProblems() {
        return this.problems;
    }

    public boolean isIgnored() {
        String value = this.getSeverity();
        return value != null && value.equals("ignore");
    }

    protected void createProblem(ISourcePosition position, String message) {
        String value = this.getSeverity();
        if (value != null && value.equals("ignore")) {
            return;
        }
        DefaultProblem problem = value != null && value.equals("error") ? new Error(position, message, this.getProblemID()) : new Warning(position, message, this.getProblemID());
        this.problems.add(problem);
    }

    protected String getSeverity() {
        return this.fOptions.get(this.getOptionKey());
    }

    protected Instruction visitNode(Node iVisited) {
        return null;
    }

    protected abstract String getOptionKey();

    public void exitClassNode(ClassNode iVisited) {
    }

    public void exitDefnNode(DefnNode iVisited) {
    }

    public void exitIfNode(IfNode iVisited) {
    }

    public void exitBlockNode(BlockNode iVisited) {
    }

    public void exitDefsNode(DefsNode iVisited) {
    }

    public void exitModuleNode(ModuleNode iVisited) {
    }

    public void exitWhenNode(WhenNode iVisited) {
    }

    public void exitSClassNode(SClassNode iVisited) {
    }

    public void exitArgsNode(ArgsNode iVisited) {
    }

    public void exitRescueBodyNode(RescueBodyNode iVisited) {
    }

    public void exitHashNode(HashNode iVisited) {
    }

    protected int getProblemID() {
        return 0;
    }
}

