/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.codeassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.search.BasicSearchEngine;

public class RubyElementRequestor {
    private IRubyScript script;

    public RubyElementRequestor(IRubyScript script) {
        this.script = script;
    }

    public IType[] findType(String fullyQualifiedName) {
        IType type;
        ArrayList<IType> types = new ArrayList<IType>();
        SearchPattern pattern = SearchPattern.createPattern(5, fullyQualifiedName, 0, 0);
        SearchParticipant[] participants = new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()};
        IRubySearchScope scope = BasicSearchEngine.createRubySearchScope(new IRubyElement[]{this.script.getRubyProject()});
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        try {
            new BasicSearchEngine().search(pattern, participants, scope, requestor, null);
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
        List<SearchMatch> matches = requestor.getResults();
        for (SearchMatch match : matches) {
            type = (IType)match.getElement();
            if (type == null || !type.getFullyQualifiedName().equals(fullyQualifiedName)) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            for (SearchMatch match : matches) {
                type = (IType)match.getElement();
                if (type == null) continue;
                types.add(type);
            }
        }
        return types.toArray(new IType[types.size()]);
    }
}

