/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.compiler;

import java.util.HashMap;
import java.util.Map;

public class CompilerOptions {
    public static final long EmptyStatement = 1L;
    public static final long ConstantReassignment = 2L;
    public static final long UnreachableCode = 4L;
    public static final long CoreClassMethodRedefinition = 8L;
    public static final long Ruby19WhenStatements = 16L;
    public static final long Ruby19HashCommaSyntax = 32L;
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public long errorThreshold = 0L;
    public long warningThreshold = 54L;

    public Map getMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(30);
        optionsMap.put("org.rubypeople.rdt.core.compiler.problem.emptyStatement", this.getSeverityString(1L));
        optionsMap.put("org.rubypeople.rdt.core.compiler.problem.constantReassignment", this.getSeverityString(2L));
        optionsMap.put("org.rubypeople.rdt.core.compiler.problem.unreachableCode", this.getSeverityString(4L));
        optionsMap.put("org.rubypeople.rdt.core.compiler.problem.redefinition.core.class.method", this.getSeverityString(8L));
        optionsMap.put("org.rubypeople.rdt.core.compiler.problem.ruby19WhenStatements", this.getSeverityString(16L));
        optionsMap.put("org.rubypeople.rdt.core.compiler.problem.ruby19HashCommaSyntax", this.getSeverityString(32L));
        return optionsMap;
    }

    public String getSeverityString(long irritant) {
        if ((this.warningThreshold & irritant) != 0L) {
            return WARNING;
        }
        if ((this.errorThreshold & irritant) != 0L) {
            return ERROR;
        }
        return IGNORE;
    }

    public void set(Map optionsMap) {
        Object optionValue = optionsMap.get("org.rubypeople.rdt.core.compiler.problem.emptyStatement");
        if (optionValue != null) {
            this.updateSeverity(1L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.rubypeople.rdt.core.compiler.problem.constantReassignment")) != null) {
            this.updateSeverity(2L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.rubypeople.rdt.core.compiler.problem.unreachableCode")) != null) {
            this.updateSeverity(4L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.rubypeople.rdt.core.compiler.problem.redefinition.core.class.method")) != null) {
            this.updateSeverity(8L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.rubypeople.rdt.core.compiler.problem.ruby19WhenStatements")) != null) {
            this.updateSeverity(16L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.rubypeople.rdt.core.compiler.problem.ruby19HashCommaSyntax")) != null) {
            this.updateSeverity(32L, optionValue);
        }
    }

    void updateSeverity(long irritant, Object severityString) {
        if (ERROR.equals(severityString)) {
            this.errorThreshold |= irritant;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (WARNING.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold |= irritant;
        } else if (IGNORE.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }
}

