/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyScript;

public class BecomeWorkingCopyOperation
extends RubyModelOperation {
    private IProblemRequestor problemRequestor;

    public BecomeWorkingCopyOperation(RubyScript workingCopy, IProblemRequestor problemRequestor) {
        super(new IRubyElement[]{workingCopy});
        this.problemRequestor = problemRequestor;
    }

    protected void executeOperation() throws RubyModelException {
        RubyScript workingCopy = this.getWorkingCopy();
        RubyModelManager.getRubyModelManager().getPerWorkingCopyInfo(workingCopy, true, true, this.problemRequestor);
        workingCopy.openWhenClosed(workingCopy.createElementInfo(), this.progressMonitor);
        if (!workingCopy.isPrimary()) {
            RubyElementDelta delta = new RubyElementDelta(this.getRubyModel());
            delta.added(workingCopy);
            this.addDelta(delta);
        } else if (workingCopy.getResource().isAccessible()) {
            RubyElementDelta delta = new RubyElementDelta(this.getRubyModel());
            delta.changed(workingCopy, 65536);
            this.addDelta(delta);
        } else {
            RubyElementDelta delta = new RubyElementDelta(this.getRubyModel());
            delta.added(workingCopy, 65536);
            this.addDelta(delta);
        }
        this.resultElements = new IRubyElement[]{workingCopy};
    }

    protected RubyScript getWorkingCopy() {
        return (RubyScript)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

