/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElementDeltaBuilder;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class CommitWorkingCopyOperation
extends RubyModelOperation {
    public CommitWorkingCopyOperation(IRubyScript element, boolean force) {
        super(new IRubyElement[]{element}, force);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws RubyModelException {
        try {
            boolean isIncluded;
            this.beginTask(Messages.workingCopy_commit, 2);
            RubyScript workingCopy = this.getRubyScript();
            IFile resource = (IFile)workingCopy.getResource();
            if (resource == null) {
                workingCopy.getBuffer().save(this.progressMonitor, this.force);
                return;
            }
            IRubyScript primary = workingCopy.getPrimary();
            boolean isPrimary = workingCopy.isPrimary();
            RubyElementDeltaBuilder deltaBuilder = null;
            boolean bl = isIncluded = !Util.isExcluded(workingCopy);
            if (isPrimary || isIncluded && resource.isAccessible() && Util.isValidRubyScriptName(workingCopy.getElementName())) {
                if (!isPrimary && !primary.isOpen()) {
                    primary.open(null);
                }
                if (!(!isIncluded || isPrimary && workingCopy.isConsistent())) {
                    deltaBuilder = new RubyElementDeltaBuilder(primary);
                }
                IBuffer primaryBuffer = primary.getBuffer();
                if (!isPrimary) {
                    if (primaryBuffer == null) {
                        return;
                    }
                    char[] primaryContents = primaryBuffer.getCharacters();
                    boolean hasSaved = false;
                    try {
                        IBuffer workingCopyBuffer = workingCopy.getBuffer();
                        if (workingCopyBuffer == null) {
                            return;
                        }
                        primaryBuffer.setContents(workingCopyBuffer.getCharacters());
                        primaryBuffer.save(this.progressMonitor, this.force);
                        primary.makeConsistent(this);
                        hasSaved = true;
                    }
                    finally {
                        if (hasSaved) return;
                        primaryBuffer.setContents(primaryContents);
                        return;
                    }
                } else {
                    primaryBuffer.save(this.progressMonitor, this.force);
                    primary.makeConsistent(this);
                }
            } else {
                String encoding = null;
                try {
                    encoding = resource.getCharset();
                }
                catch (CoreException coreException) {}
                String contents = workingCopy.getSource();
                if (contents == null) {
                    return;
                }
                try {
                    byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                    ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                    if (resource.exists()) {
                        resource.setContents((InputStream)stream, this.force ? 3 : 2, null);
                    } else {
                        resource.create((InputStream)stream, this.force, this.progressMonitor);
                    }
                }
                catch (CoreException e) {
                    throw new RubyModelException(e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RubyModelException(e, 985);
                }
            }
            this.setAttribute("hasModifiedResource", "true");
            workingCopy.updateTimeStamp((RubyScript)primary);
            workingCopy.makeConsistent(this);
            this.worked(1);
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null) {
                    this.addDelta(deltaBuilder.delta);
                }
            }
            this.worked(1);
            return;
        }
        finally {
            this.done();
        }
    }

    protected RubyScript getRubyScript() {
        return (RubyScript)this.getElementToProcess();
    }

    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getElementToProcess().getResource();
        if (resource == null) {
            return null;
        }
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    public IRubyModelStatus verify() {
        RubyScript cu = this.getRubyScript();
        if (!cu.isWorkingCopy()) {
            return new RubyModelStatus(967, cu);
        }
        if (cu.hasResourceChanged() && !this.force) {
            return new RubyModelStatus(981);
        }
        return RubyModelStatus.VERIFIED_OK;
    }
}

