/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.ASTRewrite;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.core.util.Messages;

public class CreateMethodOperation
extends RubyModelOperation {
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int insertionPolicy = 1;
    protected IRubyElement anchorElement = null;
    protected boolean creationOccurred = true;
    private String source;
    private Node cuAST;
    private Node createdNode;
    private String[] parameters;

    public CreateMethodOperation(IType parentElement, String source, boolean force) {
        super(null, new IRubyElement[]{parentElement}, force);
        this.source = source;
    }

    protected void executeOperation() throws RubyModelException {
        try {
            this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
            RubyElementDelta delta = this.newRubyElementDelta();
            IRubyScript unit = this.getRubyScript();
            this.generateNewRubyScriptAST(unit);
            if (this.creationOccurred) {
                unit.save(null, false);
                boolean isWorkingCopy = unit.isWorkingCopy();
                if (!isWorkingCopy) {
                    this.setAttribute("hasModifiedResource", "true");
                }
                this.worked(1);
                this.resultElements = this.generateResultHandles();
                if (!isWorkingCopy && unit.getParent().exists()) {
                    int i = 0;
                    while (i < this.resultElements.length) {
                        delta.added(this.resultElements[i]);
                        ++i;
                    }
                    this.addDelta(delta);
                }
            }
        }
        finally {
            this.done();
        }
    }

    protected IType getType() {
        return (IType)this.getParentElement();
    }

    protected IRubyElement generateResultHandle() {
        String[] types = this.convertASTMethodTypesToSignatures();
        String name = this.getASTNodeName();
        return this.getType().getMethod(name, types);
    }

    private String getASTNodeName() {
        if (this.createdNode instanceof DefsNode) {
            return ((DefsNode)this.createdNode).getName();
        }
        return ((DefnNode)this.createdNode).getName();
    }

    protected String[] convertASTMethodTypesToSignatures() {
        if (this.parameters == null && this.createdNode != null) {
            DefnNode methodDeclaration = (DefnNode)this.createdNode;
            this.parameters = ASTUtil.getArgs((Node)methodDeclaration.getArgsNode(), methodDeclaration.getScope());
        }
        return this.parameters;
    }

    protected IRubyElement[] generateResultHandles() {
        return new IRubyElement[]{this.generateResultHandle()};
    }

    protected IRubyScript getRubyScript() {
        return this.getRubyScriptFor(this.getParentElement());
    }

    public String getMainTaskName() {
        return Messages.operation_createMethodProgress;
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    public void createBefore(IRubyElement sibling) {
        this.setRelativePosition(sibling, 3);
    }

    protected void setRelativePosition(IRubyElement sibling, int policy) throws IllegalArgumentException {
        if (sibling == null) {
            this.anchorElement = null;
            this.insertionPolicy = 1;
        } else {
            this.anchorElement = sibling;
            this.insertionPolicy = policy;
        }
    }

    protected void generateNewRubyScriptAST(IRubyScript cu) throws RubyModelException {
        this.cuAST = this.parse(cu);
        IDocument document = this.getDocument(cu);
        ASTRewrite rewriter = ASTRewrite.create(this.cuAST, document);
        Node child = this.generateElementAST(document, cu);
        if (child != null) {
            Node parent = ((RubyElement)this.getParentElement()).findNode(this.cuAST);
            if (parent == null) {
                parent = this.cuAST;
            }
            this.insertASTNode(rewriter, parent, child);
            this.apply(rewriter, document);
        }
        this.worked(1);
    }

    private void insertASTNode(ASTRewrite rewriter, Node parent, Node child) {
        switch (this.insertionPolicy) {
            case 3: {
                Node element = ((RubyElement)this.anchorElement).findNode(this.cuAST);
                rewriter.insertBefore(this.source, child, element, null);
            }
            case 2: {
                Node element = ((RubyElement)this.anchorElement).findNode(this.cuAST);
                rewriter.insertAfter(this.source, child, element, null);
            }
            case 1: {
                rewriter.insertLast(this.source, child, null);
            }
        }
    }

    private Node generateElementAST(IDocument document, IRubyScript cu) {
        RubyParser parser = new RubyParser();
        Node root = parser.parse(this.source).getAST();
        this.createdNode = ((NewlineNode)((RootNode)root).getBodyNode()).getNextNode();
        return this.createdNode;
    }

    protected Node parse(IRubyScript cu) throws RubyModelException {
        cu.makeConsistent(this.progressMonitor);
        RubyParser parser = new RubyParser();
        return parser.parse(cu.getSource()).getAST();
    }

    protected void apply(ASTRewrite rewriter, IDocument document) throws RubyModelException {
        TextEdit edits = rewriter.rewriteAST(document, null);
        try {
            edits.apply(document);
        }
        catch (BadLocationException e) {
            throw new RubyModelException(e, 984);
        }
    }

    public IRubyModelStatus verify() {
        IRubyElement domPresentParent;
        if (this.getParentElement() == null) {
            return new RubyModelStatus(968);
        }
        if (this.anchorElement != null && !(domPresentParent = this.anchorElement.getParent()).equals(this.getParentElement())) {
            return new RubyModelStatus(993, this.anchorElement);
        }
        return RubyModelStatus.VERIFIED_OK;
    }
}

