/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class CreateSourceFolderOperation
extends RubyModelOperation {
    protected String[] pkgName;

    public CreateSourceFolderOperation(SourceFolderRoot root, String packageName, boolean force) {
        super(null, new IRubyElement[]{root}, force);
        this.pkgName = packageName == null ? null : Util.getTrimmedSimpleNames(packageName);
    }

    protected void executeOperation() throws RubyModelException {
        RubyElementDelta delta = null;
        SourceFolderRoot root = (SourceFolderRoot)this.getParentElement();
        this.beginTask(Messages.operation_createPackageFragmentProgress, this.pkgName.length);
        IContainer parentFolder = (IContainer)root.getResource();
        String[] sideEffectPackageName = CharOperation.NO_STRINGS;
        ArrayList<SourceFolder> results = new ArrayList<SourceFolder>(this.pkgName.length);
        int i = 0;
        while (i < this.pkgName.length) {
            String subFolderName = this.pkgName[i];
            sideEffectPackageName = Util.arrayConcat(sideEffectPackageName, subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                this.createFolder(parentFolder, subFolderName, this.force);
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                SourceFolder addedFrag = root.getSourceFolder(sideEffectPackageName);
                if (delta == null) {
                    delta = this.newRubyElementDelta();
                }
                delta.added(addedFrag);
                results.add(addedFrag);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            this.worked(1);
            ++i;
        }
        if (results.size() > 0) {
            this.resultElements = new IRubyElement[results.size()];
            results.toArray(this.resultElements);
            if (delta != null) {
                this.addDelta(delta);
            }
        }
        this.done();
    }

    public IRubyModelStatus verify() {
        String packageName;
        if (this.getParentElement() == null) {
            return new RubyModelStatus(968);
        }
        String string = packageName = this.pkgName == null ? null : Util.concatWith(this.pkgName, '/');
        if (this.pkgName == null) {
            return new RubyModelStatus(983, packageName);
        }
        IRubyProject root = (IRubyProject)this.getParentElement();
        if (root.isReadOnly()) {
            return new RubyModelStatus(976, root);
        }
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        while (i < this.pkgName.length) {
            IResource subFolder = parentFolder.findMember(this.pkgName[i]);
            if (subFolder != null) {
                if (subFolder.getType() != 2) {
                    return new RubyModelStatus(977, Messages.bind(Messages.status_nameCollision, subFolder.getFullPath().toString()));
                }
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return RubyModelStatus.VERIFIED_OK;
    }
}

