/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.LocalFileStorage;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.ExternalRubyScript;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderInfo;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderInfo;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class ExternalSourceFolder
extends SourceFolder {
    public ExternalSourceFolder(SourceFolderRoot parent, String[] names) {
        super(parent, names);
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws RubyModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonRubyResources() throws RubyModelException {
        return ((ExternalSourceFolderInfo)this.getElementInfo()).getNonRubyResources();
    }

    protected boolean computeChildren(OpenableElementInfo info) {
        ArrayList<ExternalRubyScript> vChildren = new ArrayList<ExternalRubyScript>();
        File file = this.getPath().toFile();
        File[] members = file.listFiles();
        ArrayList<LocalFileStorage> files = new ArrayList<LocalFileStorage>();
        int i = 0;
        int max = members.length;
        while (i < max) {
            File child = members[i];
            if (!child.isDirectory()) {
                if (Util.isValidRubyScriptName(child.getName())) {
                    ExternalRubyScript childElement = new ExternalRubyScript(this, child.getName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                    vChildren.add(childElement);
                } else {
                    files.add(new LocalFileStorage(child));
                }
            }
            ++i;
        }
        if (info instanceof SourceFolderInfo) {
            SourceFolderInfo duh = (SourceFolderInfo)info;
            duh.setNonRubyResources(files.toArray(new Object[files.size()]));
        }
        IRubyElement[] children = new IRubyElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    public IRubyScript getRubyScript(String name) {
        if (!Util.isRubyLikeFileName(name)) {
            throw new IllegalArgumentException(Messages.convention_unit_notRubyName);
        }
        return new ExternalRubyScript(this, name, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ExternalRubyScript classFile = new ExternalRubyScript(this, classFileName, owner);
                return classFile.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        if (this.isDefaultPackage()) {
            return RubyElementInfo.NO_NON_RUBY_RESOURCES;
        }
        return this.storedNonRubyResources();
    }
}

