/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.ExternalSourceFolder;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderInfo;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderRootInfo;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Util;

public class ExternalSourceFolderRoot
extends SourceFolderRoot
implements ISourceFolderRoot {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath folderPath;

    protected ExternalSourceFolderRoot(IPath resource, RubyProject project) {
        super(null, project);
        this.folderPath = resource;
    }

    public String getElementName() {
        return this.folderPath.toPortableString();
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        return ((ExternalSourceFolder)this.getSourceFolder(CharOperation.NO_STRINGS)).storedNonRubyResources();
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws RubyModelException {
        try {
            Object target = RubyModel.getTarget(this.folderPath, false);
            if (target instanceof File) {
                ArrayList vChildren = new ArrayList(5);
                this.computeFolderChildren((File)target, CharOperation.NO_STRINGS, vChildren);
                IRubyElement[] children = new IRubyElement[vChildren.size()];
                vChildren.toArray(children);
                info.setChildren(children);
                int i = 0;
                while (i < children.length) {
                    ExternalSourceFolder packFrag = (ExternalSourceFolder)children[i];
                    ExternalSourceFolderInfo fragInfo = new ExternalSourceFolderInfo();
                    packFrag.computeChildren(fragInfo);
                    newElements.put(packFrag, fragInfo);
                    ++i;
                }
            }
        }
        catch (RubyModelException e) {
            info.setChildren(new IRubyElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(File folder, String[] pkgName, ArrayList vChildren) throws RubyModelException {
        SourceFolder pkg = this.getSourceFolder(pkgName);
        vChildren.add(pkg);
        try {
            RubyModelManager manager = RubyModelManager.getRubyModelManager();
            File[] members = folder.listFiles();
            if (members == null) {
                return;
            }
            int i = 0;
            int max = members.length;
            while (i < max) {
                File member = members[i];
                String memberName = member.getName();
                if (member.isDirectory()) {
                    String[] newNames = Util.arrayConcat(pkgName, manager.intern(memberName));
                    this.computeFolderChildren(member, newNames, vChildren);
                } else {
                    member.isFile();
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new RubyModelException(e, 969);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    public SourceFolder getSourceFolder(String[] pkgName) {
        return new ExternalSourceFolder(this, pkgName);
    }

    public IPath getPath() {
        return this.folderPath;
    }

    public boolean isExternal() {
        return true;
    }

    public int hashCode() {
        return this.folderPath.hashCode();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExternalSourceFolderRoot) {
            ExternalSourceFolderRoot other = (ExternalSourceFolderRoot)o;
            return this.folderPath.equals((Object)other.folderPath);
        }
        return false;
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    protected Object createElementInfo() {
        return new ExternalSourceFolderRootInfo();
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = RubyModel.getTarget(this.folderPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    protected IStatus validateOnLoadpath() {
        return Status.OK_STATUS;
    }

    protected boolean resourceExists() {
        if (this.isExternal()) {
            return RubyModel.getTarget(this.getPath(), true) != null;
        }
        return super.resourceExists();
    }
}

