/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.ILoadpathAttribute;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.LoadpathAttribute;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.XMLWriter;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LoadpathEntry
implements ILoadpathEntry {
    public static final String TAG_LOADPATH = "loadpath";
    public static final String TAG_LOADPATHENTRY = "pathentry";
    public static final String TAG_KIND = "type";
    public static final String TAG_PATH = "path";
    public static final String TAG_EXPORTED = "exported";
    public static final String TAG_INCLUDING = "including";
    public static final String TAG_EXCLUDING = "excluding";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_ATTRIBUTE_NAME = "name";
    public static final String TAG_ATTRIBUTE_VALUE = "value";
    private static final String TYPE_PROJECT = "project";
    private String rootID;
    private int entryKind;
    private IPath path;
    private IPath[] inclusionPatterns;
    private char[][] fullInclusionPatternChars;
    private IPath[] exclusionPatterns;
    private char[][] fullExclusionPatternChars;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    public static final ILoadpathAttribute[] NO_EXTRA_ATTRIBUTES = new ILoadpathAttribute[0];
    public static final IPath[] INCLUDE_ALL = new IPath[0];
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    private IProject project;
    private boolean isExported;
    ILoadpathAttribute[] extraAttributes;

    public LoadpathEntry(int entryKind, IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, ILoadpathAttribute[] extraAttributes, boolean isExported) {
        this.path = path;
        this.entryKind = entryKind;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.extraAttributes = extraAttributes;
        if (inclusionPatterns != INCLUDE_ALL && inclusionPatterns.length > 0) {
            this.fullInclusionPatternChars = UNINIT_PATTERNS;
        }
        if (exclusionPatterns.length > 0) {
            this.fullExclusionPatternChars = UNINIT_PATTERNS;
        }
        this.isExported = isExported;
    }

    public IPath getPath() {
        return this.path;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return TYPE_PROJECT;
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
        }
        return "unknown";
    }

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<pathentry type=\"");
        buffer.append(String.valueOf(LoadpathEntry.kindToString(this.entryKind)) + "\" ");
        buffer.append("path=\"" + this.getPath() + "\"/>");
        return buffer.toString();
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullExclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullExclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullExclusionPatternChars[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullExclusionPatternChars;
    }

    public char[][] fullInclusionPatternChars() {
        if (this.fullInclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.inclusionPatterns.length;
            this.fullInclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullInclusionPatternChars[i] = prefixPath.append(this.inclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullInclusionPatternChars;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IPath[] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public LoadpathEntry combineWith(LoadpathEntry referringEntry) {
        if (referringEntry == null) {
            return this;
        }
        if (referringEntry.isExported()) {
            return new LoadpathEntry(this.getEntryKind(), this.getPath(), this.inclusionPatterns, this.exclusionPatterns, this.extraAttributes, referringEntry.isExported() || this.isExported);
        }
        return this;
    }

    public static ILoadpathEntry elementDecode(Element element, IRubyProject project, Map unknownElements) {
        IPath[] exclusionPatterns;
        IPath projectPath = project.getProject().getFullPath();
        NamedNodeMap attributes = element.getAttributes();
        NodeList children = element.getChildNodes();
        boolean[] foundChildren = new boolean[children.getLength()];
        String kindAttr = LoadpathEntry.removeAttribute(TAG_KIND, attributes);
        String pathAttr = LoadpathEntry.removeAttribute(TAG_PATH, attributes);
        Path path = new Path(pathAttr);
        int kind = LoadpathEntry.kindFromString(kindAttr);
        if (kind != 4 && kind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        boolean isExported = LoadpathEntry.removeAttribute(TAG_EXPORTED, attributes).equals("true");
        IPath[] inclusionPatterns = LoadpathEntry.decodePatterns(attributes, TAG_INCLUDING);
        if (inclusionPatterns == null) {
            inclusionPatterns = INCLUDE_ALL;
        }
        if ((exclusionPatterns = LoadpathEntry.decodePatterns(attributes, TAG_EXCLUDING)) == null) {
            exclusionPatterns = EXCLUDE_NONE;
        }
        NodeList attributeList = LoadpathEntry.getChildAttributes(TAG_ATTRIBUTES, children, foundChildren);
        ILoadpathAttribute[] extraAttributes = LoadpathEntry.decodeExtraAttributes(attributeList);
        String[] unknownAttributes = null;
        ArrayList<String> unknownChildren = null;
        if (unknownElements != null) {
            int i;
            int unknownAttributeLength = attributes.getLength();
            if (unknownAttributeLength != 0) {
                unknownAttributes = new String[unknownAttributeLength * 2];
                i = 0;
                while (i < unknownAttributeLength) {
                    Node attribute = attributes.item(i);
                    unknownAttributes[i * 2] = attribute.getNodeName();
                    unknownAttributes[i * 2 + 1] = attribute.getNodeValue();
                    ++i;
                }
            }
            i = 0;
            int length = foundChildren.length;
            while (i < length) {
                Node node;
                if (!foundChildren[i] && (node = children.item(i)).getNodeType() == 1) {
                    if (unknownChildren == null) {
                        unknownChildren = new ArrayList<String>();
                    }
                    StringBuffer buffer = new StringBuffer();
                    LoadpathEntry.decodeUnknownNode(node, buffer, project);
                    unknownChildren.add(buffer.toString());
                }
                ++i;
            }
        }
        ILoadpathEntry entry = null;
        switch (kind) {
            case 2: {
                entry = new LoadpathEntry(2, (IPath)path, INCLUDE_ALL, EXCLUDE_NONE, extraAttributes, isExported);
                break;
            }
            case 1: {
                entry = RubyCore.newLibraryEntry((IPath)path, extraAttributes, isExported);
                break;
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getElementName())) {
                    entry = RubyCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, extraAttributes);
                    break;
                }
                if (path.segmentCount() == 1) {
                    entry = RubyCore.newProjectEntry((IPath)path, extraAttributes, isExported);
                    break;
                }
                entry = RubyCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, extraAttributes);
                break;
            }
            case 4: {
                entry = RubyCore.newVariableEntry((IPath)path, extraAttributes, isExported);
                break;
            }
            case 5: {
                entry = RubyCore.newContainerEntry((IPath)path, extraAttributes, isExported);
                break;
            }
            default: {
                throw new AssertionFailedException(Messages.bind(Messages.classpath_unknownKind, kindAttr));
            }
        }
        if (unknownAttributes != null || unknownChildren != null) {
            UnknownXmlElements unknownXmlElements = new UnknownXmlElements();
            unknownXmlElements.attributes = unknownAttributes;
            unknownXmlElements.children = unknownChildren;
            unknownElements.put(path, unknownXmlElements);
        }
        return entry;
    }

    public static NodeList getChildAttributes(String childName, NodeList children, boolean[] foundChildren) {
        int i = 0;
        int length = foundChildren.length;
        while (i < length) {
            Node node = children.item(i);
            if (childName.equals(node.getNodeName())) {
                foundChildren[i] = true;
                return node.getChildNodes();
            }
            ++i;
        }
        return null;
    }

    static ILoadpathAttribute[] decodeExtraAttributes(NodeList attributes) {
        if (attributes == null) {
            return NO_EXTRA_ATTRIBUTES;
        }
        int length = attributes.getLength();
        if (length == 0) {
            return NO_EXTRA_ATTRIBUTES;
        }
        ILoadpathAttribute[] result = new ILoadpathAttribute[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            String value;
            Element attribute;
            String name;
            Node node = attributes.item(i);
            if (node.getNodeType() == 1 && (name = (attribute = (Element)node).getAttribute(TAG_ATTRIBUTE_NAME)) != null && (value = attribute.getAttribute(TAG_ATTRIBUTE_VALUE)) != null) {
                result[index++] = new LoadpathAttribute(name, value);
            }
            ++i;
        }
        if (index != length) {
            ILoadpathAttribute[] iLoadpathAttributeArray = result;
            result = new ILoadpathAttribute[index];
            System.arraycopy(iLoadpathAttributeArray, 0, result, 0, index);
        }
        return result;
    }

    private static void decodeUnknownNode(Node node, StringBuffer buffer, IRubyProject project) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter(writer, project, false);
            LoadpathEntry.decodeUnknownNode(node, xmlWriter, true);
            xmlWriter.flush();
            xmlWriter.close();
            buffer.append(s.toString("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static void decodeUnknownNode(Node node, XMLWriter xmlWriter, boolean insertNewLine) {
        switch (node.getNodeType()) {
            case 1: {
                int length;
                HashMap<String, String> parameters = null;
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null && (length = attributes.getLength()) > 0) {
                    parameters = new HashMap<String, String>();
                    int i = 0;
                    while (i < length) {
                        Node attribute = attributes.item(i);
                        parameters.put(attribute.getNodeName(), attribute.getNodeValue());
                        ++i;
                    }
                }
                NodeList children = node.getChildNodes();
                int childrenLength = children.getLength();
                String nodeName = node.getNodeName();
                xmlWriter.printTag(nodeName, parameters, false, false, childrenLength == 0);
                if (childrenLength <= 0) break;
                int i = 0;
                while (i < childrenLength) {
                    LoadpathEntry.decodeUnknownNode(children.item(i), xmlWriter, false);
                    ++i;
                }
                xmlWriter.endTag(nodeName, false, insertNewLine);
                break;
            }
            case 3: {
                String data = ((Text)node).getData();
                xmlWriter.printString(data, false, false);
            }
        }
    }

    private static IPath[] decodePatterns(NamedNodeMap nodeMap, String tag) {
        char[][] patterns;
        int patternCount;
        String sequence = LoadpathEntry.removeAttribute(tag, nodeMap);
        if (!sequence.equals("") && (patternCount = (patterns = CharOperation.splitOn('|', sequence.toCharArray())).length) > 0) {
            IPath[] paths = new IPath[patternCount];
            int index = 0;
            int j = 0;
            while (j < patternCount) {
                char[] pattern = patterns[j];
                if (pattern.length != 0) {
                    paths[index++] = new Path(new String(pattern));
                }
                ++j;
            }
            if (index < patternCount) {
                IPath[] iPathArray = paths;
                paths = new IPath[index];
                System.arraycopy(iPathArray, 0, paths, 0, index);
            }
            return paths;
        }
        return null;
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase(TYPE_PROJECT)) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        return -1;
    }

    private static String removeAttribute(String nodeName, NamedNodeMap nodeMap) {
        Node node = LoadpathEntry.removeNode(nodeName, nodeMap);
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    private static Node removeNode(String nodeName, NamedNodeMap nodeMap) {
        try {
            return nodeMap.removeNamedItem(nodeName);
        }
        catch (DOMException e) {
            if (e.code != 8) {
                throw e;
            }
            return null;
        }
    }

    public boolean isOptional() {
        int i = 0;
        int length = this.extraAttributes.length;
        while (i < length) {
            ILoadpathAttribute attribute = this.extraAttributes[i];
            if ("optional".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IRubyModelStatus validateLoadpathEntry(IRubyProject project, ILoadpathEntry rawEntry, boolean b, boolean c) {
        return RubyModelStatus.VERIFIED_OK;
    }

    public static IRubyModelStatus validateLoadpath(IRubyProject project, ILoadpathEntry[] resolvedPath, IPath projectOutputLocation) {
        return RubyModelStatus.VERIFIED_OK;
    }

    public void elementEncode(XMLWriter writer, IPath projectPath, boolean indent, boolean newLine, Map unknownElements) {
        UnknownXmlElements unknownXmlElements;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TAG_KIND, LoadpathEntry.kindToString(this.entryKind));
        IPath xmlPath = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
            if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            } else {
                xmlPath = xmlPath.makeAbsolute();
            }
        }
        parameters.put(TAG_PATH, String.valueOf(xmlPath));
        if (this.isExported) {
            parameters.put(TAG_EXPORTED, "true");
        }
        LoadpathEntry.encodePatterns(this.inclusionPatterns, TAG_INCLUDING, parameters);
        LoadpathEntry.encodePatterns(this.exclusionPatterns, TAG_EXCLUDING, parameters);
        UnknownXmlElements unknownXmlElements2 = unknownXmlElements = unknownElements == null ? null : (UnknownXmlElements)unknownElements.get(this.path);
        if (unknownXmlElements != null) {
            String[] unknownAttributes = unknownXmlElements.attributes;
            if (unknownXmlElements.attributes != null) {
                int i = 0;
                int length = unknownAttributes.length;
                while (i < length) {
                    String tagName = unknownAttributes[i];
                    String tagValue = unknownAttributes[i + 1];
                    parameters.put(tagName, tagValue);
                    i += 2;
                }
            }
        }
        boolean hasExtraAttributes = this.extraAttributes.length != 0;
        ArrayList unknownChildren = unknownXmlElements != null ? unknownXmlElements.children : null;
        boolean hasUnknownChildren = unknownChildren != null;
        writer.printTag(TAG_LOADPATHENTRY, parameters, indent, newLine, !hasUnknownChildren);
        if (hasExtraAttributes) {
            this.encodeExtraAttributes(writer, indent, newLine);
        }
        if (hasUnknownChildren) {
            this.encodeUnknownChildren(writer, indent, newLine, unknownChildren);
            if (hasExtraAttributes || hasUnknownChildren) {
                writer.endTag(TAG_LOADPATHENTRY, indent, true);
            }
        }
    }

    void encodeExtraAttributes(XMLWriter writer, boolean indent, boolean newLine) {
        writer.startTag(TAG_ATTRIBUTES, indent);
        int i = 0;
        while (i < this.extraAttributes.length) {
            ILoadpathAttribute attribute = this.extraAttributes[i];
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(TAG_ATTRIBUTE_NAME, attribute.getName());
            parameters.put(TAG_ATTRIBUTE_VALUE, attribute.getValue());
            writer.printTag(TAG_ATTRIBUTE, parameters, indent, newLine, true);
            ++i;
        }
        writer.endTag(TAG_ATTRIBUTES, indent, true);
    }

    private static void encodePatterns(IPath[] patterns, String tag, Map parameters) {
        if (patterns != null && patterns.length > 0) {
            StringBuffer rule = new StringBuffer(10);
            int i = 0;
            int max = patterns.length;
            while (i < max) {
                if (i > 0) {
                    rule.append('|');
                }
                rule.append(patterns[i]);
                ++i;
            }
            parameters.put(tag, String.valueOf(rule));
        }
    }

    private void encodeUnknownChildren(XMLWriter writer, boolean indent, boolean newLine, ArrayList unknownChildren) {
        int i = 0;
        int length = unknownChildren.size();
        while (i < length) {
            String child = (String)unknownChildren.get(i);
            writer.printString(child, indent, false);
            ++i;
        }
    }

    public ILoadpathAttribute[] getExtraAttributes() {
        return this.extraAttributes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LoadpathEntry) {
            LoadpathEntry otherEntry = (LoadpathEntry)object;
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != otherEntry.isExported()) {
                return false;
            }
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            if (!LoadpathEntry.equalPatterns(this.inclusionPatterns, otherEntry.getInclusionPatterns())) {
                return false;
            }
            if (!LoadpathEntry.equalPatterns(this.exclusionPatterns, otherEntry.getExclusionPatterns())) {
                return false;
            }
            return LoadpathEntry.equalAttributes(this.extraAttributes, otherEntry.getExtraAttributes());
        }
        return false;
    }

    private static boolean equalAttributes(ILoadpathAttribute[] firstAttributes, ILoadpathAttribute[] secondAttributes) {
        if (firstAttributes != secondAttributes) {
            if (firstAttributes == null) {
                return false;
            }
            int length = firstAttributes.length;
            if (secondAttributes == null || secondAttributes.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!firstAttributes[i].equals(secondAttributes[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean equalPatterns(IPath[] firstPatterns, IPath[] secondPatterns) {
        if (firstPatterns != secondPatterns) {
            if (firstPatterns == null) {
                return false;
            }
            int length = firstPatterns.length;
            if (secondPatterns == null || secondPatterns.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!firstPatterns[i].toString().equals(secondPatterns[i].toString())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.getPath().toPortableString();
    }

    static class UnknownXmlElements {
        String[] attributes;
        ArrayList children;

        UnknownXmlElements() {
        }
    }
}

