/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.MemberElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyFieldElementInfo;
import org.rubypeople.rdt.internal.core.RubyMethodElementInfo;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyTypeElementInfo;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class RubyElementDeltaBuilder {
    IRubyElement rubyElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    public RubyElementDelta delta;
    ArrayList added;
    ArrayList removed;

    public RubyElementDeltaBuilder(IRubyElement rubyElement) {
        this.rubyElement = rubyElement;
        this.initialize();
        this.recordElementInfo(rubyElement, (RubyModel)this.rubyElement.getRubyModel(), 0);
    }

    public RubyElementDeltaBuilder(IRubyElement rubyElement, int maxDepth) {
        this.rubyElement = rubyElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(rubyElement, (RubyModel)this.rubyElement.getRubyModel(), 0);
    }

    private void added(IRubyElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public void buildDeltas() {
        this.recordNewPositions(this.rubyElement, 0);
        this.findAdditions(this.rubyElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.rubyElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private void findAdditions(IRubyElement newElement, int depth) {
        IRubyElement[] children;
        RubyElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        RubyElementInfo newInfo = null;
        try {
            newInfo = (RubyElementInfo)((RubyElement)newElement).getElementInfo();
        }
        catch (RubyModelException rubyModelException) {
            return;
        }
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void findChangesInPositioning(IRubyElement element, int depth) {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.changed(element, 256);
        }
        if (element instanceof IParent) {
            RubyElementInfo info = null;
            try {
                info = (RubyElementInfo)((RubyElement)element).getElementInfo();
            }
            catch (RubyModelException rubyModelException) {
                return;
            }
            IRubyElement[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findContentChange(RubyElementInfo oldInfo, RubyElementInfo newInfo, IRubyElement newElement) {
        if (oldInfo instanceof MemberElementInfo && newInfo instanceof MemberElementInfo) {
            if (oldInfo instanceof RubyMethodElementInfo && newInfo instanceof RubyMethodElementInfo) {
                RubyMethodElementInfo oldSourceMethodInfo = (RubyMethodElementInfo)oldInfo;
                RubyMethodElementInfo newSourceMethodInfo = (RubyMethodElementInfo)newInfo;
                if (oldSourceMethodInfo.getVisibility() != newSourceMethodInfo.getVisibility()) {
                    this.delta.changed(newElement, 2);
                }
                if (!CharOperation.equals(oldSourceMethodInfo.getArgumentNames(), newSourceMethodInfo.getArgumentNames())) {
                    this.delta.changed(newElement, 1);
                }
            } else if (oldInfo instanceof RubyFieldElementInfo && newInfo instanceof RubyFieldElementInfo && ((RubyFieldElementInfo)oldInfo).getTypeName() != null && ((RubyFieldElementInfo)newInfo).getTypeName() != null && !((RubyFieldElementInfo)oldInfo).getTypeName().equals(((RubyFieldElementInfo)newInfo).getTypeName())) {
                this.delta.changed(newElement, 1);
            }
        }
        if (oldInfo instanceof RubyTypeElementInfo && newInfo instanceof RubyTypeElementInfo) {
            RubyTypeElementInfo oldSourceTypeInfo = (RubyTypeElementInfo)oldInfo;
            RubyTypeElementInfo newSourceTypeInfo = (RubyTypeElementInfo)newInfo;
            if (!(oldSourceTypeInfo.getSuperclassName() == null || newSourceTypeInfo.getSuperclassName() == null || oldSourceTypeInfo.getSuperclassName().equals(newSourceTypeInfo.getSuperclassName()) && CharOperation.equals(oldSourceTypeInfo.getIncludedModuleNames(), newSourceTypeInfo.getIncludedModuleNames()))) {
                this.delta.changed(newElement, 2048);
            }
        }
    }

    private void findDeletions() {
        for (IRubyElement element : this.infos.keySet()) {
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private RubyElementInfo getElementInfo(IRubyElement element) {
        return (RubyElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(IRubyElement element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(IRubyElement element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.rubyElement, new ListItem(null, null));
        this.putNewPosition(this.rubyElement, new ListItem(null, null));
        this.delta = new RubyElementDelta(this.rubyElement);
        if (this.rubyElement.getElementType() >= 4) {
            this.delta.fineGrained();
        }
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IRubyElement[] elements, boolean isNew) {
        int length = elements.length;
        IRubyElement previous = null;
        IRubyElement current = null;
        IRubyElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IRubyElement iRubyElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.putNewPosition(current, new ListItem(previous, next));
            } else {
                this.putOldPosition(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isPositionedCorrectly(IRubyElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IRubyElement oldPrevious = oldListItem.previous;
        IRubyElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private void putElementInfo(IRubyElement element, RubyElementInfo info) {
        this.infos.put(element, info);
    }

    private void putNewPosition(IRubyElement element, ListItem position) {
        this.newPositions.put(element, position);
    }

    private void putOldPosition(IRubyElement element, ListItem position) {
        this.oldPositions.put(element, position);
    }

    private void recordElementInfo(IRubyElement element, RubyModel model, int depth) {
        IRubyElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        RubyElementInfo info = (RubyElementInfo)RubyModelManager.getRubyModelManager().getInfo(element);
        if (info == null) {
            return;
        }
        this.putElementInfo(element, info);
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.recordElementInfo(children[i], model, depth + 1);
                ++i;
            }
        }
    }

    private void recordNewPositions(IRubyElement newElement, int depth) {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            RubyElementInfo info = null;
            try {
                info = (RubyElementInfo)((RubyElement)newElement).getElementInfo();
            }
            catch (RubyModelException rubyModelException) {
                return;
            }
            IRubyElement[] children = info.getChildren();
            if (children != null) {
                this.insertPositions(children, true);
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.recordNewPositions(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void removed(IRubyElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(IRubyElement element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(RubyElementDelta elementDelta) {
        if (elementDelta.getKind() == 2) {
            IRubyElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                elementDelta.removeAffectedChild((RubyElementDelta)children[i]);
                ++i;
            }
        } else {
            IRubyElementDelta[] children = elementDelta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.trimDelta((RubyElementDelta)children[i]);
                ++i;
            }
        }
    }

    class ListItem {
        public IRubyElement previous;
        public IRubyElement next;

        public ListItem(IRubyElement previous, IRubyElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

