/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyModelInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Messages;

public class RubyModel
extends Openable
implements IRubyModel {
    public static HashSet<File> existingExternalFiles = new HashSet();
    public static HashSet existingExternalConfirmedFolders = new HashSet();

    protected RubyModel() {
        super(null);
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
        existingExternalConfirmedFolders = new HashSet();
    }

    protected Object createElementInfo() {
        return new RubyModelInfo();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RubyModel)) {
            return false;
        }
        return super.equals(o);
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        return ((RubyModelInfo)this.getElementInfo()).getNonRubyResources();
    }

    public IRubyProject findRubyProject(IProject project) {
        try {
            IRubyProject[] projects = this.getRubyProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IRubyProject rubyProject = projects[i];
                if (project.equals((Object)rubyProject.getProject())) {
                    return rubyProject;
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return null;
    }

    public int getElementType() {
        return 0;
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IRubyProject[] getRubyProjects() throws RubyModelException {
        ArrayList<IRubyElement> list = this.getChildrenOfType(1);
        IRubyProject[] array = new IRubyProject[list.size()];
        list.toArray(array);
        return array;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            IProject project = projects[i];
            if (RubyProject.hasRubyNature(project)) {
                info.addChild(this.getRubyProject((IResource)project));
            }
            ++i;
        }
        newElements.put(this, info);
        return true;
    }

    public IRubyProject getRubyProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new RubyProject(((IFolder)resource).getProject(), this);
            }
            case 1: {
                return new RubyProject(((IFile)resource).getProject(), this);
            }
            case 4: {
                return new RubyProject((IProject)resource, this);
            }
        }
        throw new IllegalArgumentException(Messages.bind(Messages.element_invalidResourceForProject));
    }

    public IRubyProject getRubyProject(String projectName) {
        return new RubyProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), this);
    }

    public static Object getTarget(IPath path, boolean checkResourceExistence) {
        IResource target = RubyModel.getWorkspaceTarget(path);
        if (target != null) {
            return target;
        }
        return RubyModel.getExternalTarget(path, checkResourceExistence);
    }

    public static IResource getWorkspaceTarget(IPath path) {
        if (path == null || path.getDevice() != null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return null;
        }
        return workspace.getRoot().findMember(path);
    }

    public static Object getExternalTarget(IPath path, boolean checkResourceExistence) {
        if (path == null) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        File linkedFolder = RubyModel.getFolder(externalFile);
        if (linkedFolder != null) {
            if (checkResourceExistence && !externalFile.exists()) {
                return null;
            }
            return linkedFolder;
        }
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (RubyModel.existingExternalFilesContains(externalFile)) {
            return externalFile;
        }
        if (RubyModelManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [RubyModel.getTarget(...)] Checking existence of " + path.toString());
        }
        if (externalFile.isFile()) {
            RubyModel.existingExternalFilesAdd(externalFile);
            return externalFile;
        }
        return null;
    }

    private static synchronized void existingExternalFilesAdd(File externalFile) {
        existingExternalFiles.add(externalFile);
    }

    private static synchronized boolean existingExternalFilesContains(File externalFile) {
        return existingExternalFiles.contains(externalFile);
    }

    public static boolean isFolder(Object target) {
        return RubyModel.getFolder(target) != null;
    }

    public static synchronized File getFolder(Object target) {
        File f;
        if (existingExternalConfirmedFolders.contains(target)) {
            return (File)target;
        }
        if (target instanceof File && (f = (File)target).isDirectory()) {
            existingExternalConfirmedFolders.add(f);
            return f;
        }
        return null;
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '=': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String projectName = memento.nextToken();
                RubyElement project = (RubyElement)((Object)this.getRubyProject(projectName));
                return project.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected void getHandleMemento(StringBuffer buff) {
        buff.append(this.getElementName());
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    public boolean contains(IResource resource) {
        IRubyProject[] projects;
        switch (resource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            projects = this.getRubyProjects();
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            RubyProject project = (RubyProject)projects[i];
            if (!project.contains(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void refreshExternalArchives(IRubyElement[] elementsScope, IProgressMonitor monitor) throws RubyModelException {
        if (elementsScope == null) {
            elementsScope = new IRubyElement[]{this};
        }
        RubyModelManager.getRubyModelManager().getDeltaProcessor().checkExternalArchiveChanges(elementsScope, monitor);
    }
}

