/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.CompletionRequestor;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.codeassist.CompletionEngine;
import org.rubypeople.rdt.internal.core.ASTHolderCUInfo;
import org.rubypeople.rdt.internal.core.BecomeWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.CommitWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.DiscardWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.ImportContainer;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.ReconcileWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyImport;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScriptElementInfo;
import org.rubypeople.rdt.internal.core.RubyScriptProblemFinder;
import org.rubypeople.rdt.internal.core.RubyScriptStructureBuilder;
import org.rubypeople.rdt.internal.core.RubyType;
import org.rubypeople.rdt.internal.core.SourceElementParser;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.buffer.BufferManager;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyScript
extends Openable
implements IRubyScript {
    public WorkingCopyOwner owner;
    protected String name;
    public Node lastGoodAST;

    public RubyScript(SourceFolder parent, String name, WorkingCopyOwner owner) {
        super(parent);
        this.name = name;
        this.owner = owner;
    }

    protected Object createElementInfo() {
        return new RubyScriptElementInfo();
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws RubyModelException {
        HashMap problems;
        boolean createAST;
        IStatus status;
        if (!this.isWorkingCopy() && !(status = this.validateRubyScript(underlyingResource)).isOK()) {
            throw this.newRubyModelException(status);
        }
        if (!this.isPrimary() && this.getPerWorkingCopyInfo() == null) {
            throw this.newNotPresentException();
        }
        RubyScriptElementInfo unitInfo = (RubyScriptElementInfo)info;
        char[] contents = this.getCharacters(pm, unitInfo);
        RubyModelManager.PerWorkingCopyInfo perWorkingCopyInfo = this.getPerWorkingCopyInfo();
        IRubyProject project = this.getRubyProject();
        if (info instanceof ASTHolderCUInfo) {
            ASTHolderCUInfo astHolder = (ASTHolderCUInfo)info;
            createAST = true;
            problems = astHolder.problems;
        } else {
            createAST = false;
            problems = null;
        }
        boolean computeProblems = RubyProject.hasRubyNature(project.getProject()) && perWorkingCopyInfo != null && perWorkingCopyInfo.isActive();
        Node ast = null;
        try {
            RubyScriptStructureBuilder requestor = new RubyScriptStructureBuilder(this, unitInfo, newElements);
            SourceElementParser sp = new SourceElementParser(requestor){

                public Instruction visitRootNode(RootNode iVisited) {
                    RubyScript.this.lastGoodAST = iVisited;
                    return super.visitRootNode(iVisited);
                }
            };
            sp.parse(contents, this.getElementName().toCharArray());
            ast = this.lastGoodAST;
            unitInfo.setIsStructureKnown(true);
        }
        catch (SyntaxException e) {
            unitInfo.setIsStructureKnown(false);
            unitInfo.setSyntaxException(e);
        }
        catch (Exception e) {
            RubyCore.log(e);
        }
        if (underlyingResource == null) {
            underlyingResource = this.getResource();
        }
        unitInfo.timestamp = ((IFile)underlyingResource).getModificationStamp();
        if (computeProblems) {
            if (problems == null) {
                problems = new HashMap();
                RubyScriptProblemFinder.process(this, contents, problems, pm);
                try {
                    perWorkingCopyInfo.beginReporting();
                    for (CategorizedProblem[] categorizedProblems : problems.values()) {
                        if (categorizedProblems == null) continue;
                        int i = 0;
                        int length = categorizedProblems.length;
                        while (i < length) {
                            perWorkingCopyInfo.acceptProblem(categorizedProblems[i]);
                            ++i;
                        }
                    }
                }
                finally {
                    perWorkingCopyInfo.endReporting();
                }
            } else {
                RubyScriptProblemFinder.process(this, contents, problems, pm);
            }
            perWorkingCopyInfo.endReporting();
        }
        if (createAST) {
            ((ASTHolderCUInfo)info).ast = (RootNode)ast;
        }
        return unitInfo.isStructureKnown();
    }

    protected char[] getCharacters(IProgressMonitor pm, RubyScriptElementInfo unitInfo) throws RubyModelException {
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer == null) {
            buffer = this.openBuffer(pm, unitInfo);
        }
        char[] contents = buffer == null ? null : buffer.getCharacters();
        return contents;
    }

    protected void updateTimeStamp(RubyScript original) throws RubyModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new RubyModelException(new RubyModelStatus(995));
        }
        ((RubyScriptElementInfo)this.getElementInfo()).timestamp = timeStamp;
    }

    protected IStatus validateRubyScript(IResource resource) {
        SourceFolderRoot root = this.getSourceFolderRoot();
        if (resource != null) {
            char[][] exclusionPatterns;
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            if (Util.isExcluded(resource, inclusionPatterns, exclusionPatterns = root.fullExclusionPatternChars())) {
                return new RubyModelStatus(1006, this);
            }
            if (!resource.isAccessible()) {
                return new RubyModelStatus(969, this);
            }
        }
        return RubyConventions.validateRubyScriptName(this.getElementName());
    }

    public IRubyElement getElementAt(int position) throws RubyModelException {
        IRubyElement e = this.getSourceElementAt(position);
        if (e == this) {
            return null;
        }
        return e;
    }

    public String getElementName() {
        return this.name;
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        if (this.isWorkingCopy() && !this.isPrimary()) {
            return null;
        }
        return super.getUnderlyingResource();
    }

    public IResource getResource() {
        SourceFolderRoot root = this.getSourceFolderRoot();
        if (root == null) {
            return null;
        }
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public void close() throws RubyModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return;
        }
        super.close();
    }

    protected void closing(Object info) {
        if (this.getPerWorkingCopyInfo() == null) {
            super.closing(info);
        }
    }

    public WorkingCopyOwner getOwner() {
        return this.isPrimary() || !this.isWorkingCopy() ? null : this.owner;
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IRubyScript getPrimary() {
        return (IRubyScript)this.getPrimaryElement(true);
    }

    public IRubyElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new RubyScript((SourceFolder)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY);
    }

    public int getElementType() {
        return 4;
    }

    public void reconcile() throws RubyModelException {
        this.reconcile(false, null, null);
    }

    public RootNode reconcile(boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws RubyModelException {
        if (!this.isWorkingCopy()) {
            return null;
        }
        if (workingCopyOwner == null) {
            workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        }
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, forceProblemDetection, workingCopyOwner);
        op.runOperation(monitor);
        return op.ast;
    }

    public IRubyScript getRubyScript() {
        return this;
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (RubyModelException rubyModelException) {
            return new char[0];
        }
    }

    public ISourceRange getSourceRange() throws RubyModelException {
        return ((RubyScriptElementInfo)this.getElementInfo()).getSourceRange();
    }

    public IType getType(String typeName) {
        return new RubyType(this, typeName);
    }

    public String getSource() throws RubyModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws RubyModelException {
        IBuffer buffer;
        boolean isWorkingCopy = this.isWorkingCopy();
        IBuffer iBuffer = buffer = isWorkingCopy ? this.owner.createBuffer(this) : BufferManager.getDefaultBufferManager().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            if (isWorkingCopy) {
                RubyScript original;
                if (!this.isPrimary() && (original = new RubyScript((SourceFolder)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY)).isOpen()) {
                    buffer.setContents(original.getSource());
                } else {
                    IFile file = (IFile)this.getResource();
                    if (file == null || !file.exists()) {
                        buffer.setContents(new char[0]);
                    } else {
                        buffer.setContents(Util.getResourceContentsAsCharArray(file));
                    }
                }
            } else {
                IFile file = (IFile)this.getResource();
                if (file == null || !file.exists()) {
                    throw this.newNotPresentException();
                }
                buffer.setContents(Util.getResourceContentsAsCharArray(file));
            }
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public boolean isPrimary() {
        return this.owner == DefaultWorkingCopyOwner.PRIMARY;
    }

    public boolean isWorkingCopy() {
        return !this.isPrimary() || this.getPerWorkingCopyInfo() != null;
    }

    public RubyModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return RubyModelManager.getRubyModelManager().getPerWorkingCopyInfo(this, false, false, null);
    }

    public IRubyScript getWorkingCopy(IProgressMonitor monitor) throws RubyModelException {
        return this.getWorkingCopy(new WorkingCopyOwner(){}, null, monitor);
    }

    public IRubyScript getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws RubyModelException {
        RubyScript workingCopy;
        if (!this.isPrimary()) {
            return this;
        }
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        RubyModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new RubyScript((SourceFolder)this.getParent(), this.getElementName(), workingCopyOwner), false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, problemRequestor);
        op.runOperation(monitor);
        return workingCopy;
    }

    public void becomeWorkingCopy(IProblemRequestor requestor, IProgressMonitor monitor) throws RubyModelException {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        RubyModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(this, false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(this, requestor);
            operation.runOperation(monitor);
        }
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws RubyModelException {
        CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
        op.runOperation(monitor);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RubyScript)) {
            return false;
        }
        RubyScript other = (RubyScript)obj;
        return this.owner.equals(other.owner) && super.equals(obj);
    }

    public boolean exists() {
        if (this.getPerWorkingCopyInfo() != null) {
            return true;
        }
        return this.isPrimary();
    }

    public boolean canBeRemovedFromCache() {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBeRemovedFromCache();
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBufferBeRemovedFromCache(buffer);
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = RubyModelManager.getRubyModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        return ((RubyScriptElementInfo)info).timestamp != this.getResource().getModificationStamp();
    }

    public boolean isConsistent() {
        return !RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().contains(this);
    }

    public void makeConsistent(IProgressMonitor monitor) throws RubyModelException {
        this.makeConsistent(false, null, monitor);
    }

    public RootNode makeConsistent(boolean createAST, HashMap problems, IProgressMonitor monitor) throws RubyModelException {
        if (this.isConsistent()) {
            return null;
        }
        if (createAST) {
            ASTHolderCUInfo info = new ASTHolderCUInfo();
            info.problems = problems;
            this.openWhenClosed(info, monitor);
            RootNode result = info.ast;
            info.ast = null;
            return result;
        }
        this.openWhenClosed(this.createElementInfo(), monitor);
        return null;
    }

    public void discardWorkingCopy() throws RubyModelException {
        DiscardWorkingCopyOperation op = new DiscardWorkingCopyOperation(this);
        op.runOperation(null);
    }

    public void save(IProgressMonitor pm, boolean force) throws RubyModelException {
        if (this.isWorkingCopy()) {
            this.reconcile();
        } else {
            super.save(pm, force);
        }
    }

    public IImportDeclaration[] getImports() throws RubyModelException {
        IImportContainer container = this.getImportContainer();
        if (container.exists()) {
            IRubyElement[] elements = container.getChildren();
            IImportDeclaration[] imprts = new IImportDeclaration[elements.length];
            System.arraycopy(elements, 0, imprts, 0, elements.length);
            return imprts;
        }
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return new IImportDeclaration[0];
    }

    public IImportDeclaration getImport(String importName) {
        return new RubyImport((ImportContainer)this.getImportContainer(), importName);
    }

    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    public IType[] getTypes() throws RubyModelException {
        ArrayList<IRubyElement> list = this.getChildrenOfType(5);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public IType findPrimaryType() {
        String typeName = Util.getNameWithoutRubyLikeExtension(this.getElementName());
        IType primaryType = this.getType(typeName = Util.identifierToConstant(typeName));
        if (primaryType.exists()) {
            return primaryType;
        }
        try {
            IType[] types = this.getTypes();
            if (types != null && types.length > 0) {
                return types[0];
            }
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return null;
    }

    public IRubyElement[] codeSelect(int offset, int length) throws RubyModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IRubyElement[] codeSelect(int offset, int length, WorkingCopyOwner workingCopyOwner) throws RubyModelException {
        return super.codeSelect(this, offset, length, workingCopyOwner);
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws RubyModelException {
        CompletionEngine engine = new CompletionEngine(requestor);
        engine.complete(this, offset);
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '#': {
                RubyElement container = (RubyElement)((Object)this.getImportContainer());
                return container.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                RubyElement type = (RubyElement)((Object)this.getType(typeName));
                return type.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '{';
    }

    public IType[] getAllTypes() throws RubyModelException {
        IType[] types = this.getTypes();
        ArrayList<IType> allTypes = new ArrayList<IType>(types.length);
        ArrayList<IType> typesToTraverse = new ArrayList<IType>(types.length);
        int i = 0;
        while (i < types.length) {
            typesToTraverse.add(types[i]);
            ++i;
        }
        while (!typesToTraverse.isEmpty()) {
            IType type = (IType)typesToTraverse.get(0);
            typesToTraverse.remove(type);
            allTypes.add(type);
            types = type.getTypes();
            i = 0;
            while (i < types.length) {
                typesToTraverse.add(types[i]);
                ++i;
            }
        }
        IType[] arrayOfAllTypes = new IType[allTypes.size()];
        allTypes.toArray(arrayOfAllTypes);
        return arrayOfAllTypes;
    }
}

