/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.parser.warnings.DelegatingVisitor;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.builder.SyntaxExceptionHandler;
import org.rubypeople.rdt.internal.core.parser.RdtWarnings;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.parser.TaskParser;
import org.rubypeople.rdt.internal.core.parser.TaskTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyScriptProblemFinder {
    public static RootNode process(RubyScript script, char[] charContents, HashMap problems, IProgressMonitor pm) {
        RdtWarnings warnings = new RdtWarnings(script.getElementName());
        String contents = new String(charContents);
        List<Object> generatedProblems = new ArrayList<CategorizedProblem>();
        RootNode ast = null;
        try {
            ast = RubyScriptProblemFinder.parse(script, contents, warnings);
            generatedProblems = RubyScriptProblemFinder.runLint(script, ast, contents);
        }
        catch (SyntaxException e) {
            generatedProblems.add(SyntaxExceptionHandler.handle(e, contents));
        }
        TaskParser taskParser = new TaskParser(script.getRubyProject().getOptions(true));
        taskParser.parse(contents);
        generatedProblems.addAll(warnings.getWarnings());
        List<TaskTag> tasks = taskParser.getTasks();
        problems.put("org.rubypeople.rdt.core.problem", generatedProblems.toArray(new CategorizedProblem[generatedProblems.size()]));
        problems.put("org.rubypeople.rdt.core.task", tasks.toArray(new CategorizedProblem[tasks.size()]));
        return ast;
    }

    private static RootNode parse(RubyScript script, String contents, IRubyWarnings warnings) {
        try {
            RubyParser parser = new RubyParser(warnings);
            return (RootNode)parser.parse((IFile)script.getUnderlyingResource(), contents).getAST();
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
            return null;
        }
    }

    private static List<CategorizedProblem> runLint(RubyScript script, RootNode node, String contents) {
        if (node == null) {
            return new ArrayList<CategorizedProblem>();
        }
        List<RubyLintVisitor> visitors = DelegatingVisitor.createVisitors(script, contents);
        DelegatingVisitor visitor = new DelegatingVisitor(visitors);
        node.accept((NodeVisitor)visitor);
        return visitor.getProblems();
    }
}

