/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.compiler.ISourceElementRequestor;
import org.rubypeople.rdt.internal.core.HandleStack;
import org.rubypeople.rdt.internal.core.ImportContainer;
import org.rubypeople.rdt.internal.core.ImportDeclarationElementInfo;
import org.rubypeople.rdt.internal.core.InfoStack;
import org.rubypeople.rdt.internal.core.LocalVariable;
import org.rubypeople.rdt.internal.core.RubyBlock;
import org.rubypeople.rdt.internal.core.RubyClassVar;
import org.rubypeople.rdt.internal.core.RubyConstant;
import org.rubypeople.rdt.internal.core.RubyDynamicVar;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyField;
import org.rubypeople.rdt.internal.core.RubyFieldElementInfo;
import org.rubypeople.rdt.internal.core.RubyGlobal;
import org.rubypeople.rdt.internal.core.RubyImport;
import org.rubypeople.rdt.internal.core.RubyInstVar;
import org.rubypeople.rdt.internal.core.RubyMethod;
import org.rubypeople.rdt.internal.core.RubyMethodElementInfo;
import org.rubypeople.rdt.internal.core.RubyModule;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.RubyScriptElementInfo;
import org.rubypeople.rdt.internal.core.RubyType;
import org.rubypeople.rdt.internal.core.RubyTypeElementInfo;
import org.rubypeople.rdt.internal.core.SourceRefElementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyScriptStructureBuilder
implements ISourceElementRequestor {
    private InfoStack infoStack;
    private HandleStack modelStack;
    private RubyScriptElementInfo scriptInfo;
    private IRubyScript script;
    private Map<IRubyElement, RubyElementInfo> newElements;
    private RubyElementInfo importContainerInfo;

    public RubyScriptStructureBuilder(IRubyScript script, RubyScriptElementInfo info, Map<IRubyElement, RubyElementInfo> newElements) {
        this.script = script;
        this.scriptInfo = info;
        this.newElements = newElements;
        this.infoStack = new InfoStack();
        this.modelStack = new HandleStack();
        this.modelStack.push(script);
        this.infoStack.push(this.scriptInfo);
    }

    private RubyElementInfo getCurrentTypeInfo() {
        ArrayList<RubyElementInfo> extras = new ArrayList<RubyElementInfo>();
        RubyElementInfo element = this.infoStack.peek();
        while (!(element instanceof RubyTypeElementInfo)) {
            extras.add(this.infoStack.pop());
            element = this.infoStack.peek();
            if (element == null) break;
        }
        Collections.reverse(extras);
        Iterator iter = extras.iterator();
        while (iter.hasNext()) {
            this.infoStack.push((RubyElementInfo)iter.next());
        }
        if (element == null) {
            return this.scriptInfo;
        }
        return element;
    }

    private RubyType findChild(RubyElement parent, int type, String name) {
        block4: {
            if (parent.exists()) break block4;
            return null;
        }
        try {
            ArrayList<IRubyElement> children = parent.getChildrenOfType(type);
            for (IRubyElement element : children) {
                if (!element.getElementName().equals(name)) continue;
                return (RubyType)element;
            }
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return null;
    }

    private RubyElement getCurrentType() {
        ArrayList<RubyElement> extras = new ArrayList<RubyElement>();
        RubyElement element = this.modelStack.peek();
        while (!element.isType(5)) {
            extras.add(this.modelStack.pop());
            element = this.modelStack.peek();
            if (element == null) break;
        }
        Collections.reverse(extras);
        Iterator iter = extras.iterator();
        while (iter.hasNext()) {
            this.modelStack.push((IRubyElement)iter.next());
        }
        if (element == null) {
            return (RubyScript)this.script;
        }
        return element;
    }

    @Override
    public void acceptConstructorReference(String name, int argCount, int offset) {
    }

    @Override
    public void acceptFieldReference(String name, int offset) {
    }

    @Override
    public void acceptImport(String value, int startOffset, int endOffset) {
        ImportContainer importContainer = (ImportContainer)this.script.getImportContainer();
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new RubyElementInfo();
            this.scriptInfo.addChild(importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        RubyImport handle = new RubyImport(importContainer, value);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setNameSourceStart(startOffset);
        info.setNameSourceEnd(endOffset);
        info.setSourceRangeStart(startOffset);
        info.setSourceRangeEnd(endOffset);
        info.name = value;
        this.importContainerInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    @Override
    public void acceptMethodReference(String name, int argCount, int offset) {
    }

    @Override
    public void acceptProblem(CategorizedProblem problem) {
    }

    @Override
    public void acceptTypeReference(String name, int startOffset, int endOffset) {
    }

    @Override
    public void acceptUnknownReference(String name, int startOffset, int endOffset) {
    }

    @Override
    public void enterConstructor(ISourceElementRequestor.MethodInfo constructor) {
        this.enterMethod(constructor);
    }

    @Override
    public void enterField(ISourceElementRequestor.FieldInfo field) {
        RubyField handle;
        if (field.name.startsWith("@@")) {
            handle = new RubyClassVar(this.getCurrentType(), field.name);
        } else if (field.name.startsWith("@")) {
            handle = new RubyInstVar(this.getCurrentType(), field.name);
        } else if (field.name.startsWith("$")) {
            handle = new RubyGlobal(this.script, field.name);
        } else if (Character.isUpperCase(field.name.charAt(0))) {
            handle = new RubyConstant(this.getCurrentType(), field.name);
        } else {
            int start = field.declarationStart - field.name.length() + 1;
            int end = start + field.name.length();
            handle = field.isDynamic ? new RubyDynamicVar(this.modelStack.peek(), field.name, start, end) : new LocalVariable(this.modelStack.peek(), field.name, start, end);
        }
        this.modelStack.push(handle);
        RubyElementInfo parentInfo = handle instanceof LocalVariable || handle instanceof RubyDynamicVar ? this.infoStack.peek() : (handle instanceof RubyGlobal ? this.scriptInfo : this.getCurrentTypeInfo());
        parentInfo.addChild(handle);
        RubyFieldElementInfo info = new RubyFieldElementInfo();
        info.setSourceRangeStart(field.declarationStart);
        info.setNameSourceStart(field.nameSourceStart);
        info.setNameSourceEnd(field.nameSourceEnd);
        this.infoStack.push(info);
        this.newElements.put(handle, info);
    }

    @Override
    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        RubyMethod method = new RubyMethod(this.getCurrentType(), methodInfo.name, methodInfo.parameterNames);
        this.modelStack.push(method);
        this.infoStack.peek().addChild(method);
        RubyMethodElementInfo info = new RubyMethodElementInfo();
        info.setArgumentNames(methodInfo.parameterNames);
        info.setVisibility(methodInfo.visibility);
        info.setNameSourceStart(methodInfo.nameSourceStart);
        info.setNameSourceEnd(methodInfo.nameSourceEnd);
        info.setSourceRangeStart(methodInfo.declarationStart);
        info.setIsSingleton(methodInfo.isClassLevel);
        this.infoStack.push(info);
        this.newElements.put(method, info);
    }

    @Override
    public void acceptYield(String name) {
        ((RubyMethodElementInfo)this.infoStack.peek()).addBlockVar(name);
    }

    @Override
    public void enterScript() {
    }

    @Override
    public void enterType(ISourceElementRequestor.TypeInfo type) {
        RubyType handle = type.isModule ? new RubyModule(this.modelStack.peek(), type.name) : new RubyType(this.modelStack.peek(), type.name);
        RubyElement parent = this.modelStack.peek();
        RubyType existing = this.findChild(parent, 5, type.name);
        if (existing != null) {
            handle.occurrenceCount = existing.occurrenceCount + 1;
        }
        this.modelStack.push(handle);
        this.infoStack.peek().addChild(handle);
        RubyTypeElementInfo info = new RubyTypeElementInfo();
        info.setHandle(handle);
        info.setNameSourceStart(type.nameSourceStart);
        info.setNameSourceEnd(type.nameSourceEnd);
        info.setSourceRangeStart(type.declarationStart);
        info.setSuperclassName(type.superclass);
        info.setIncludedModuleNames(type.modules);
        this.infoStack.push(info);
        this.newElements.put(handle, info);
    }

    @Override
    public void exitConstructor(int endOffset) {
        this.exitMethod(endOffset);
    }

    @Override
    public void exitField(int endOffset) {
        RubyFieldElementInfo info = (RubyFieldElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(endOffset);
        this.modelStack.pop();
    }

    @Override
    public void exitMethod(int endOffset) {
        RubyMethodElementInfo info = (RubyMethodElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(endOffset);
        this.modelStack.pop();
    }

    @Override
    public void exitScript(int endOffset) {
        this.modelStack.pop();
        this.infoStack.pop();
    }

    @Override
    public void exitType(int endOffset) {
        RubyTypeElementInfo info = (RubyTypeElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(endOffset);
        this.modelStack.pop();
    }

    @Override
    public void acceptMixin(String string) {
        RubyElementInfo info = this.getCurrentTypeInfo();
        if (!(info instanceof RubyTypeElementInfo)) {
            return;
        }
        RubyTypeElementInfo parentType = (RubyTypeElementInfo)info;
        String[] importedModuleNames = parentType.getIncludedModuleNames();
        LinkedList<String> mergedModuleNames = new LinkedList<String>();
        if (importedModuleNames != null) {
            mergedModuleNames.addAll((Collection)Arrays.asList(importedModuleNames));
        }
        mergedModuleNames.add(string);
        String[] newIncludedModuleNames = mergedModuleNames.toArray(new String[0]);
        parentType.setIncludedModuleNames(newIncludedModuleNames);
    }

    @Override
    public void acceptMethodVisibilityChange(String methodName, int visibility) {
        RubyElementInfo info = this.getCurrentTypeInfo();
        if (!(info instanceof RubyTypeElementInfo)) {
            return;
        }
        RubyTypeElementInfo parentType = (RubyTypeElementInfo)info;
        IMethod[] methods = parentType.getMethods();
        int i = 0;
        while (i < methods.length) {
            RubyMethod method = (RubyMethod)methods[i];
            if (method.getElementName().equals(methodName)) {
                try {
                    RubyMethodElementInfo methodInfo = (RubyMethodElementInfo)method.getElementInfo();
                    methodInfo.setVisibility(visibility);
                    return;
                }
                catch (RubyModelException e) {
                    RubyCore.log((Exception)((Object)e));
                }
            }
            ++i;
        }
    }

    @Override
    public void acceptModuleFunction(String methodName) {
        RubyElementInfo info = this.getCurrentTypeInfo();
        if (!(info instanceof RubyTypeElementInfo)) {
            return;
        }
        RubyTypeElementInfo parentType = (RubyTypeElementInfo)info;
        IMethod[] methods = parentType.getMethods();
        int i = 0;
        while (i < methods.length) {
            RubyMethod method = (RubyMethod)methods[i];
            if (method.getElementName().equals(methodName)) {
                try {
                    RubyMethodElementInfo methodInfo = (RubyMethodElementInfo)method.getElementInfo();
                    methodInfo.setIsSingleton(true);
                    return;
                }
                catch (RubyModelException e) {
                    RubyCore.log((Exception)((Object)e));
                }
            }
            ++i;
        }
    }

    @Override
    public void acceptBlock(int startOffset, int endOffset) {
        RubyBlock method = new RubyBlock(this.modelStack.peek());
        this.infoStack.peek().addChild(method);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(startOffset);
        info.setSourceRangeEnd(endOffset);
        this.newElements.put(method, info);
    }
}

