/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.CreateRubyScriptOperation;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.ERBScript;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.SourceFolderInfo;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class SourceFolder
extends Openable
implements ISourceFolder {
    public String[] names;

    public SourceFolder(SourceFolderRoot parent, String[] names) {
        super(parent);
        this.names = names;
    }

    public boolean hasChildren() throws RubyModelException {
        return this.getChildren().length > 0;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws RubyModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        if (Util.isExcluded(this)) {
            throw this.newNotPresentException();
        }
        HashSet<IRubyScript> vChildren = new HashSet<IRubyScript>();
        try {
            SourceFolderRoot root = this.getSourceFolderRoot();
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            IResource[] members = ((IContainer)underlyingResource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource child = members[i];
                if (child.getType() != 2 && !Util.isExcluded(child, inclusionPatterns, exclusionPatterns)) {
                    RubyScript childElement;
                    if (Util.isValidRubyScriptName(child.getName())) {
                        childElement = new RubyScript(this, child.getName(), DefaultWorkingCopyOwner.PRIMARY);
                        vChildren.add(childElement);
                    } else if (Util.isERBLikeFileName(child.getName())) {
                        childElement = new ERBScript(this, child.getName(), DefaultWorkingCopyOwner.PRIMARY);
                        vChildren.add(childElement);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
        IRubyScript[] primaryCompilationUnits = this.getRubyScripts(DefaultWorkingCopyOwner.PRIMARY);
        int i = 0;
        int length = primaryCompilationUnits.length;
        while (i < length) {
            IRubyScript primary = primaryCompilationUnits[i];
            vChildren.add(primary);
            ++i;
        }
        IRubyElement[] children = new IRubyElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected Object createElementInfo() {
        return new SourceFolderInfo();
    }

    public int getElementType() {
        return 3;
    }

    public String getElementName() {
        if (this.names.length == 0) {
            return "";
        }
        return Util.concatWith(this.names, File.separatorChar);
    }

    public boolean containsRubyResources() throws RubyModelException {
        return ((SourceFolderInfo)this.getElementInfo()).containsRubyResources();
    }

    public IRubyScript createRubyScript(String name, String contents, boolean force, IProgressMonitor monitor) throws RubyModelException {
        CreateRubyScriptOperation op = new CreateRubyScriptOperation(this, name, contents, force);
        op.runOperation(monitor);
        return new RubyScript(this, name, DefaultWorkingCopyOwner.PRIMARY);
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        if (this.isDefaultPackage()) {
            return RubyElementInfo.NO_NON_RUBY_RESOURCES;
        }
        return ((SourceFolderInfo)this.getElementInfo()).getNonRubyResources(this.getResource(), this.getSourceFolderRoot());
    }

    public boolean isDefaultPackage() {
        return this.names.length == 0;
    }

    public IRubyScript[] getRubyScripts() throws RubyModelException {
        ArrayList<IRubyElement> list = this.getChildrenOfType(4);
        IRubyScript[] array = new IRubyScript[list.size()];
        list.toArray(array);
        return array;
    }

    public IRubyScript[] getRubyScripts(WorkingCopyOwner owner) throws RubyModelException {
        IRubyScript[] workingCopies = RubyModelManager.getRubyModelManager().getWorkingCopies(owner, false);
        if (workingCopies == null) {
            return RubyModelManager.NO_WORKING_COPY;
        }
        int length = workingCopies.length;
        IRubyScript[] result = new IRubyScript[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IRubyScript wc = workingCopies[i];
            if (this.equals(wc.getParent()) && !Util.isExcluded(wc)) {
                result[index++] = wc;
            }
            ++i;
        }
        if (index != length) {
            IRubyScript[] iRubyScriptArray = result;
            result = new IRubyScript[index];
            System.arraycopy(iRubyScriptArray, 0, result, 0, index);
        }
        return result;
    }

    public IPath getPath() {
        SourceFolderRoot root = this.getSourceFolderRoot();
        IPath path = root.getPath();
        int i = 0;
        int length = this.names.length;
        while (i < length) {
            String name = this.names[i];
            path = path.append(name);
            ++i;
        }
        return path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceFolder)) {
            return false;
        }
        SourceFolder other = (SourceFolder)o;
        return Util.equalArraysOrNull(this.names, other.names) && this.parent.equals(other.parent);
    }

    public boolean exists() {
        return super.exists() && !Util.isExcluded(this);
    }

    public IResource getResource() {
        SourceFolderRoot root = this.getSourceFolderRoot();
        if (root.isExternal()) {
            return root.getResource();
        }
        int length = this.names.length;
        if (length == 0) {
            return root.getResource();
        }
        Path path = new Path(this.names[0]);
        int i = 1;
        while (i < length) {
            path = path.append(this.names[i]);
            ++i;
        }
        return ((IContainer)root.getResource()).getFolder((IPath)path);
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        IResource rootResource = this.parent.getUnderlyingResource();
        if (rootResource == null) {
            return null;
        }
        if (rootResource.getType() == 2 || rootResource.getType() == 4) {
            IContainer folder = (IContainer)rootResource;
            String[] segs = this.names;
            int i = 0;
            while (i < segs.length) {
                IResource child = folder.findMember(segs[i]);
                if (child == null || child.getType() != 2) {
                    throw this.newNotPresentException();
                }
                folder = (IFolder)child;
                ++i;
            }
            return folder;
        }
        return rootResource;
    }

    public IRubyScript getRubyScript(String name) {
        if (Util.isERBLikeFileName(name)) {
            return new ERBScript(this, name, DefaultWorkingCopyOwner.PRIMARY);
        }
        if (!Util.isRubyLikeFileName(name)) {
            throw new IllegalArgumentException(Messages.convention_unit_notRubyName);
        }
        return new RubyScript(this, name, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String cuName = memento.nextToken();
                RubyScript cu = new RubyScript(this, cuName, owner);
                return cu.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '<';
    }

    public boolean hasSubfolders() throws RubyModelException {
        IRubyElement[] packages = ((ISourceFolderRoot)this.getParent()).getChildren();
        int namesLength = this.names.length;
        int i = 0;
        int length = packages.length;
        while (i < length) {
            block4: {
                String[] otherNames = ((SourceFolder)packages[i]).names;
                if (otherNames.length > namesLength) {
                    int j = 0;
                    while (j < namesLength) {
                        if (this.names[j].equals(otherNames[j])) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

