/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.buffer;

import java.text.NumberFormat;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.buffer.Buffer;
import org.rubypeople.rdt.internal.core.buffer.BufferCache;
import org.rubypeople.rdt.internal.core.buffer.OverflowingLRUCache;

public class BufferManager {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    public static boolean VERBOSE;
    protected OverflowingLRUCache openBuffers = new BufferCache(60);

    public void addBuffer(IBuffer buffer) {
        if (VERBOSE) {
            String owner = ((Openable)buffer.getOwner()).toString();
            System.out.println("Adding buffer for " + owner);
        }
        this.openBuffers.put(buffer.getOwner(), buffer);
        if (VERBOSE) {
            System.out.println("-> Buffer cache filling ratio = " + NumberFormat.getInstance().format(this.openBuffers.fillingRatio()) + "%");
        }
    }

    public IBuffer createBuffer(IOpenable owner) {
        IRubyElement element = (IRubyElement)((Object)owner);
        IResource resource = element.getResource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable owner) {
        return (IBuffer)this.openBuffers.get(owner);
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    public void removeBuffer(IBuffer buffer) {
        this.openBuffers.remove(buffer.getOwner());
    }
}

