/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResourceDelta;

public class ResourceDeltaFormatter {
    static Map flagMap = new HashMap();

    static {
        ResourceDeltaFormatter.putFlag(256, "Content");
        ResourceDeltaFormatter.putFlag(0x100000, "Encoding");
        ResourceDeltaFormatter.putFlag(524288, "Description");
        ResourceDeltaFormatter.putFlag(16384, "Open");
        ResourceDeltaFormatter.putFlag(32768, "Type");
        ResourceDeltaFormatter.putFlag(65536, "Sync");
        ResourceDeltaFormatter.putFlag(131072, "Markers");
        ResourceDeltaFormatter.putFlag(4096, "Moved-from");
        ResourceDeltaFormatter.putFlag(8192, "Moved-to");
    }

    public String format(IResourceDelta delta) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.kindAsString(delta.getKind()));
        buffer.append(this.flagsAsString(delta.getFlags()));
        buffer.append(delta.getFullPath());
        buffer.append("\n");
        IResourceDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta childDelta = affectedChildren[i];
            buffer.append(this.format(childDelta));
            ++i;
        }
        return buffer.toString();
    }

    private String flagsAsString(int flags) {
        StringBuffer buffer = new StringBuffer();
        for (Integer flag : flagMap.keySet()) {
            if ((flags & flag) == 0) continue;
            buffer.append(flagMap.get(flag) + " ");
        }
        return buffer.toString();
    }

    private String kindAsString(int kind) {
        switch (kind) {
            case 1: {
                return "Added  ";
            }
            case 2: {
                return "Removed";
            }
            case 4: {
                return "Changed";
            }
            case 8: {
                return "AddedPh";
            }
            case 16: {
                return "RemovPh";
            }
        }
        return String.valueOf(kind);
    }

    private static void putFlag(int flag, String description) {
        flagMap.put(new Integer(flag), description);
    }
}

