/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.hierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.hierarchy.HierarchyResolver;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;

public abstract class HierarchyBuilder {
    protected TypeHierarchy hierarchy;
    protected Map infoToHandle;
    protected String focusQualifiedName;
    protected HierarchyResolver hierarchyResolver;

    public HierarchyBuilder(TypeHierarchy hierarchy) throws RubyModelException {
        this.hierarchy = hierarchy;
        RubyProject project = (RubyProject)hierarchy.rubyProject();
        IType focusType = hierarchy.getType();
        IRubyScript unitToLookInside = focusType == null ? null : focusType.getRubyScript();
        IRubyScript[] workingCopies = this.hierarchy.workingCopies;
        if (unitToLookInside != null) {
            int wcLength;
            int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
            if (wcLength == 0) {
                IRubyScript[] unitsToLookInside = new IRubyScript[]{unitToLookInside};
            } else {
                IRubyScript[] unitsToLookInside = new IRubyScript[wcLength + 1];
                unitsToLookInside[0] = unitToLookInside;
                System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
            }
        } else {
            IRubyScript[] unitsToLookInside = workingCopies;
        }
        if (project != null) {
            this.hierarchyResolver = new HierarchyResolver(project.getOptions(true), this);
        }
        this.infoToHandle = new HashMap(5);
        this.focusQualifiedName = focusType == null ? null : focusType.getFullyQualifiedName();
    }

    public abstract void build(boolean var1) throws RubyModelException, CoreException;

    public void connect(IType typeHandle, IType superclassHandle, IType[] superinterfaceHandles) {
        if (typeHandle == null) {
            return;
        }
        if (TypeHierarchy.DEBUG) {
            System.out.println("Connecting: " + ((RubyElement)((Object)typeHandle)).toStringWithAncestors());
            System.out.println("  to superclass: " + (superclassHandle == null ? "<None>" : ((RubyElement)((Object)superclassHandle)).toStringWithAncestors()));
            System.out.print("  and superinterfaces:");
            if (superinterfaceHandles == null || superinterfaceHandles.length == 0) {
                System.out.println(" <None>");
            } else {
                System.out.println();
                int i = 0;
                int length = superinterfaceHandles.length;
                while (i < length) {
                    if (superinterfaceHandles[i] != null) {
                        System.out.println("    " + ((RubyElement)((Object)superinterfaceHandles[i])).toStringWithAncestors());
                    }
                    ++i;
                }
            }
        }
        if (typeHandle.isModule()) {
            this.hierarchy.addModule(typeHandle);
        } else if (superclassHandle == null) {
            this.hierarchy.addRootClass(typeHandle);
        } else {
            this.hierarchy.cacheSuperclass(typeHandle, superclassHandle);
        }
        if (superinterfaceHandles == null) {
            superinterfaceHandles = TypeHierarchy.NO_TYPE;
        }
        this.hierarchy.cacheSuperModules(typeHandle, superinterfaceHandles);
        this.hierarchy.cacheFlags(typeHandle, 0);
    }

    protected IType getType() {
        return this.hierarchy.getType();
    }

    protected void buildSupertypes() {
        IType focusType = this.getType();
        if (focusType == null) {
            return;
        }
        this.hierarchyResolver.resolve(focusType);
        if (!this.hierarchy.contains(focusType)) {
            this.hierarchy.addRootClass(focusType);
        }
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }
}

