/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.hierarchy;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRegion;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.Region;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.TypeVector;
import org.rubypeople.rdt.internal.core.hierarchy.HierarchyBuilder;
import org.rubypeople.rdt.internal.core.hierarchy.RegionBasedHierarchyBuilder;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedTypeHierarchy
extends TypeHierarchy {
    protected IRegion region;

    public RegionBasedTypeHierarchy(IRegion region, IRubyScript[] workingCopies, IType type, boolean computeSubtypes) {
        super(type, workingCopies, (IRubySearchScope)null, computeSubtypes);
        Region newRegion = new Region(){

            public void add(IRubyElement element) {
                if (!this.contains(element)) {
                    this.removeAllChildren(element);
                    this.fRootElements.add(element);
                    if (element.getElementType() == 1) {
                        try {
                            ISourceFolderRoot[] roots = ((IRubyProject)element).getSourceFolderRoots();
                            int i = 0;
                            int length = roots.length;
                            while (i < length) {
                                if (roots[i].isArchive() && !this.fRootElements.contains(roots[i])) {
                                    this.fRootElements.add(roots[i]);
                                }
                                ++i;
                            }
                        }
                        catch (RubyModelException rubyModelException) {}
                    }
                    this.fRootElements.trimToSize();
                }
            }
        };
        IRubyElement[] elements = region.getElements();
        int i = 0;
        int length = elements.length;
        while (i < length) {
            newRegion.add(elements[i]);
            ++i;
        }
        this.region = newRegion;
        if (elements.length > 0) {
            this.project = elements[0].getRubyProject();
        }
    }

    protected void initializeRegions() {
        super.initializeRegions();
        IRubyElement[] roots = this.region.getElements();
        int i = 0;
        while (i < roots.length) {
            IRubyElement root = roots[i];
            if (root instanceof IOpenable) {
                this.files.put(root, new ArrayList());
            } else {
                Openable o = (Openable)((RubyElement)root).getOpenableParent();
                if (o != null) {
                    this.files.put(o, new ArrayList());
                }
            }
            this.checkCanceled();
            ++i;
        }
    }

    protected void compute() throws RubyModelException, CoreException {
        RegionBasedHierarchyBuilder builder = new RegionBasedHierarchyBuilder(this);
        ((HierarchyBuilder)builder).build(this.computeSubtypes);
    }

    protected boolean isAffectedByOpenable(IRubyElementDelta delta, IRubyElement element) {
        if (element instanceof RubyScript && ((RubyScript)element).isWorkingCopy()) {
            return super.isAffectedByOpenable(delta, element);
        }
        if (this.focusType == null) {
            return this.region.contains(element);
        }
        return super.isAffectedByOpenable(delta, element);
    }

    public IRubyProject rubyProject() {
        return this.project;
    }

    public void pruneDeadBranches() {
        this.pruneDeadBranches(this.getRootClasses());
        this.pruneDeadBranches(this.getRootModules());
    }

    private boolean pruneDeadBranches(IType type) {
        TypeVector subtypes = (TypeVector)this.typeToSubtypes.get(type);
        if (subtypes == null) {
            return true;
        }
        this.pruneDeadBranches(subtypes.copy().elements());
        subtypes = (TypeVector)this.typeToSubtypes.get(type);
        return subtypes == null || subtypes.size == 0;
    }

    private void pruneDeadBranches(IType[] types) {
        int i = 0;
        int length = types.length;
        while (i < length) {
            IType type = types[i];
            if (this.pruneDeadBranches(type) && !this.region.contains(type)) {
                this.removeType(type);
            }
            ++i;
        }
    }

    protected void removeType(IType type) {
        IType[] superinterfaces;
        TypeVector types;
        IType superclass;
        IType[] subtypes = this.getSubtypes(type);
        this.typeToSubtypes.remove(type);
        if (subtypes != null) {
            int i = 0;
            while (i < subtypes.length) {
                this.removeType(subtypes[i]);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.remove(type)) != null && (types = (TypeVector)this.typeToSubtypes.get(superclass)) != null) {
            types.remove(type);
        }
        if ((superinterfaces = (IType[])this.typeToSuperModules.remove(type)) != null) {
            int i = 0;
            int length = superinterfaces.length;
            while (i < length) {
                IType superinterface = superinterfaces[i];
                TypeVector types2 = (TypeVector)this.typeToSubtypes.get(superinterface);
                if (types2 != null) {
                    types2.remove(type);
                }
                ++i;
            }
        }
        this.modules.remove(type);
    }
}

