/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.hierarchy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.ITypeHierarchyChangedListener;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.Region;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.TypeVector;
import org.rubypeople.rdt.internal.core.hierarchy.ChangeCollector;
import org.rubypeople.rdt.internal.core.hierarchy.HierarchyBuilder;
import org.rubypeople.rdt.internal.core.hierarchy.IndexBasedHierarchyBuilder;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class TypeHierarchy
implements ITypeHierarchy,
IElementChangedListener {
    public static boolean DEBUG = false;
    static final byte VERSION = 0;
    static final byte SEPARATOR1 = 10;
    static final byte SEPARATOR2 = 44;
    static final byte SEPARATOR3 = 62;
    static final byte SEPARATOR4 = 13;
    static final byte COMPUTE_SUBTYPES = 1;
    static final byte CLASS = 0;
    static final byte INTERFACE = 1;
    static final byte COMPUTED_FOR = 2;
    static final byte ROOT = 4;
    static final byte[] NO_FLAGS = new byte[0];
    static final int SIZE = 10;
    protected IRubyProject project;
    protected IType focusType;
    protected IRubyScript[] workingCopies;
    protected Map classToSuperclass;
    protected Map typeToSuperModules;
    protected Map typeToSubtypes;
    protected Map typeFlags;
    protected TypeVector rootClasses = new TypeVector();
    protected ArrayList modules = new ArrayList(10);
    public ArrayList missingTypes = new ArrayList(4);
    protected static final IType[] NO_TYPE = new IType[0];
    protected IProgressMonitor progressMonitor = null;
    protected ArrayList changeListeners = null;
    public Map files = null;
    protected Region packageRegion = null;
    protected Region projectRegion = null;
    protected boolean computeSubtypes;
    IRubySearchScope scope;
    public boolean needsRefresh = true;
    protected ChangeCollector changeCollector;

    public TypeHierarchy() {
    }

    public TypeHierarchy(IType type, IRubyScript[] workingCopies, IRubyProject project, boolean computeSubtypes) {
        this(type, workingCopies, SearchEngine.createRubySearchScope(new IRubyElement[]{project}), computeSubtypes);
        this.project = project;
    }

    public TypeHierarchy(IType type, IRubyScript[] workingCopies, IRubySearchScope scope, boolean computeSubtypes) {
        this.focusType = type == null ? null : (IType)((RubyElement)((Object)type)).unresolved();
        this.workingCopies = workingCopies;
        this.computeSubtypes = computeSubtypes;
        this.scope = scope;
    }

    protected void initializeRegions() {
        IType[] allTypes = this.getAllTypes();
        int i = 0;
        while (i < allTypes.length) {
            IType type = allTypes[i];
            Openable o = (Openable)((RubyElement)((Object)type)).getOpenableParent();
            if (o != null) {
                ArrayList<IType> types = (ArrayList<IType>)this.files.get(o);
                if (types == null) {
                    types = new ArrayList<IType>();
                    this.files.put(o, types);
                }
                types.add(type);
            }
            ISourceFolder pkg = type.getSourceFolder();
            this.packageRegion.add(pkg);
            IRubyProject declaringProject = type.getRubyProject();
            if (declaringProject != null) {
                this.projectRegion.add(declaringProject);
            }
            this.checkCanceled();
            ++i;
        }
    }

    private void addAllCheckingDuplicates(ArrayList list, IType[] collection) {
        int i = 0;
        while (i < collection.length) {
            IType element = collection[i];
            if (!list.contains(element)) {
                list.add(element);
            }
            ++i;
        }
    }

    protected void addModule(IType type) {
        this.modules.add(type);
    }

    protected void addRootClass(IType type) {
        if (this.rootClasses.contains(type)) {
            return;
        }
        this.rootClasses.add(type);
    }

    protected void addSubtype(IType type, IType subtype) {
        TypeVector subtypes = (TypeVector)this.typeToSubtypes.get(type);
        if (subtypes == null) {
            subtypes = new TypeVector();
            this.typeToSubtypes.put(type, subtypes);
        }
        if (!subtypes.contains(subtype)) {
            subtypes.add(subtype);
        }
    }

    public synchronized void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList<ITypeHierarchyChangedListener> listeners = this.changeListeners;
        if (listeners == null) {
            this.changeListeners = listeners = new ArrayList<ITypeHierarchyChangedListener>();
        }
        if (listeners.size() == 0) {
            RubyCore.addElementChangedListener(this);
        }
        if (listeners.indexOf(listener) == -1) {
            listeners.add(listener);
        }
    }

    private static Integer bytesToFlags(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return new Integer(new String(bytes));
        }
        return null;
    }

    public void cacheFlags(IType type, int flags) {
        this.typeFlags.put(type, new Integer(flags));
    }

    protected void cacheSuperclass(IType type, IType superclass) {
        if (superclass != null) {
            this.classToSuperclass.put(type, superclass);
            this.addSubtype(superclass, type);
        }
    }

    protected void cacheSuperModules(IType type, IType[] supermodules) {
        this.typeToSuperModules.put(type, supermodules);
        int i = 0;
        while (i < supermodules.length) {
            IType supermodule = supermodules[i];
            if (supermodule != null) {
                this.addModule(supermodule);
                this.addSubtype(supermodule, type);
            }
            ++i;
        }
    }

    protected void checkCanceled() {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void compute() throws RubyModelException, CoreException {
        if (this.focusType != null) {
            IndexBasedHierarchyBuilder builder = new IndexBasedHierarchyBuilder(this, this.scope);
            ((HierarchyBuilder)builder).build(this.computeSubtypes);
        }
    }

    public boolean contains(IType type) {
        if (this.classToSuperclass.get(type) != null) {
            return true;
        }
        if (this.rootClasses.contains(type)) {
            return true;
        }
        return this.modules.contains(type);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.needsRefresh) {
            return;
        }
        if (this.isAffected(event.getDelta())) {
            this.needsRefresh = true;
            this.fireChange();
        }
    }

    public boolean exists() {
        if (!this.needsRefresh) {
            return true;
        }
        return (this.focusType == null || this.focusType.exists()) && this.rubyProject().exists();
    }

    public void fireChange() {
        ArrayList listeners = this.changeListeners;
        if (listeners == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("FIRING hierarchy change [" + Thread.currentThread() + "]");
            if (this.focusType != null) {
                System.out.println("    for hierarchy focused on " + ((RubyElement)((Object)this.focusType)).toStringWithAncestors());
            }
        }
        listeners = (ArrayList)listeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            final ITypeHierarchyChangedListener listener = (ITypeHierarchyChangedListener)listeners.get(i);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Util.log(exception, "Exception occurred in listener of Type hierarchy change notification");
                }

                public void run() throws Exception {
                    listener.typeHierarchyChanged(TypeHierarchy.this);
                }
            });
            ++i;
        }
    }

    private static byte[] flagsToBytes(Integer flags) {
        if (flags != null) {
            return flags.toString().getBytes();
        }
        return NO_FLAGS;
    }

    public IType[] getAllClasses() {
        TypeVector classes = this.rootClasses.copy();
        Iterator iter = this.classToSuperclass.keySet().iterator();
        while (iter.hasNext()) {
            classes.add((IType)iter.next());
        }
        return classes.elements();
    }

    public IType[] getAllModules() {
        IType[] collection = new IType[this.modules.size()];
        this.modules.toArray(collection);
        return collection;
    }

    public IType[] getAllSubtypes(IType type) {
        return this.getAllSubtypesForType(type);
    }

    private IType[] getAllSubtypesForType(IType type) {
        ArrayList subTypes = new ArrayList();
        this.getAllSubtypesForType0(type, subTypes);
        IType[] subClasses = new IType[subTypes.size()];
        subTypes.toArray(subClasses);
        return subClasses;
    }

    private void getAllSubtypesForType0(IType type, ArrayList subs) {
        IType[] subTypes = this.getSubtypesForType(type);
        if (subTypes.length != 0) {
            int i = 0;
            while (i < subTypes.length) {
                IType subType = subTypes[i];
                subs.add(subType);
                this.getAllSubtypesForType0(subType, subs);
                ++i;
            }
        }
    }

    public IType[] getAllSuperclasses(IType type) {
        IType superclass = this.getSuperclass(type);
        TypeVector supers = new TypeVector();
        while (superclass != null) {
            supers.add(superclass);
            superclass = this.getSuperclass(superclass);
        }
        return supers.elements();
    }

    public IType[] getAllSuperModules(IType type) {
        ArrayList supers = new ArrayList();
        if (this.typeToSuperModules.get(type) == null) {
            return NO_TYPE;
        }
        this.getAllSuperModules0(type, supers);
        IType[] supermodules = new IType[supers.size()];
        supers.toArray(supermodules);
        return supermodules;
    }

    private void getAllSuperModules0(IType type, ArrayList supers) {
        IType superclass;
        IType[] superinterfaces = (IType[])this.typeToSuperModules.get(type);
        if (superinterfaces != null && superinterfaces.length != 0) {
            this.addAllCheckingDuplicates(supers, superinterfaces);
            int i = 0;
            while (i < superinterfaces.length) {
                this.getAllSuperModules0(superinterfaces[i], supers);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.get(type)) != null) {
            this.getAllSuperModules0(superclass, supers);
        }
    }

    public IType[] getAllSupertypes(IType type) {
        ArrayList supers = new ArrayList();
        if (this.typeToSuperModules.get(type) == null) {
            return NO_TYPE;
        }
        this.getAllSupertypes0(type, supers);
        IType[] supertypes = new IType[supers.size()];
        supers.toArray(supertypes);
        return supertypes;
    }

    private void getAllSupertypes0(IType type, ArrayList supers) {
        IType superclass;
        IType[] superinterfaces = (IType[])this.typeToSuperModules.get(type);
        if (superinterfaces != null && superinterfaces.length != 0) {
            this.addAllCheckingDuplicates(supers, superinterfaces);
            int i = 0;
            while (i < superinterfaces.length) {
                this.getAllSuperModules0(superinterfaces[i], supers);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.get(type)) != null) {
            supers.add(superclass);
            this.getAllSupertypes0(superclass, supers);
        }
    }

    public IType[] getAllTypes() {
        IType[] classes = this.getAllClasses();
        int classesLength = classes.length;
        IType[] allInterfaces = this.getAllModules();
        int interfacesLength = allInterfaces.length;
        IType[] all = new IType[classesLength + interfacesLength];
        System.arraycopy(classes, 0, all, 0, classesLength);
        System.arraycopy(allInterfaces, 0, all, classesLength, interfacesLength);
        return all;
    }

    public int getCachedFlags(IType type) {
        Integer flagObject = (Integer)this.typeFlags.get(type);
        if (flagObject != null) {
            return flagObject;
        }
        return -1;
    }

    public IType[] getExtendingModules(IType type) {
        if (!this.isModule(type)) {
            return NO_TYPE;
        }
        return this.getExtendingModules0(type);
    }

    private IType[] getExtendingModules0(IType extendedInterface) {
        Iterator iter = this.typeToSuperModules.keySet().iterator();
        ArrayList<IType> interfaceList = new ArrayList<IType>();
        while (iter.hasNext()) {
            IType[] superInterfaces;
            IType type = (IType)iter.next();
            if (!this.isModule(type) || (superInterfaces = (IType[])this.typeToSuperModules.get(type)) == null) continue;
            int i = 0;
            while (i < superInterfaces.length) {
                IType superInterface = superInterfaces[i];
                if (superInterface.equals(extendedInterface)) {
                    interfaceList.add(type);
                }
                ++i;
            }
        }
        IType[] extendingInterfaces = new IType[interfaceList.size()];
        interfaceList.toArray(extendingInterfaces);
        return extendingInterfaces;
    }

    public IType[] getIncludingClasses(IType type) {
        if (!this.isModule(type)) {
            return NO_TYPE;
        }
        return this.getIncludingClasses0(type);
    }

    private IType[] getIncludingClasses0(IType interfce) {
        Iterator iter = this.typeToSuperModules.keySet().iterator();
        ArrayList<IType> iMenters = new ArrayList<IType>();
        while (iter.hasNext()) {
            IType type = (IType)iter.next();
            if (this.isModule(type)) continue;
            IType[] types = (IType[])this.typeToSuperModules.get(type);
            int i = 0;
            while (i < types.length) {
                IType iFace = types[i];
                if (iFace.equals(interfce)) {
                    iMenters.add(type);
                }
                ++i;
            }
        }
        IType[] implementers = new IType[iMenters.size()];
        iMenters.toArray(implementers);
        return implementers;
    }

    public IType[] getRootClasses() {
        return this.rootClasses.elements();
    }

    public IType[] getRootModules() {
        IType[] allInterfaces = this.getAllModules();
        IType[] roots = new IType[allInterfaces.length];
        int rootNumber = 0;
        int i = 0;
        while (i < allInterfaces.length) {
            IType[] superInterfaces = this.getSuperModules(allInterfaces[i]);
            if (superInterfaces == null || superInterfaces.length == 0) {
                roots[rootNumber++] = allInterfaces[i];
            }
            ++i;
        }
        IType[] result = new IType[rootNumber];
        if (result.length > 0) {
            System.arraycopy(roots, 0, result, 0, rootNumber);
        }
        return result;
    }

    public IType[] getSubclasses(IType type) {
        if (this.isModule(type)) {
            return NO_TYPE;
        }
        TypeVector vector = (TypeVector)this.typeToSubtypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    public IType[] getSubtypes(IType type) {
        return this.getSubtypesForType(type);
    }

    private IType[] getSubtypesForType(IType type) {
        TypeVector vector = (TypeVector)this.typeToSubtypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    public IType getSuperclass(IType type) {
        if (this.isModule(type)) {
            return null;
        }
        return (IType)this.classToSuperclass.get(type);
    }

    public IType[] getSuperModules(IType type) {
        IType[] types = (IType[])this.typeToSuperModules.get(type);
        if (types == null) {
            return NO_TYPE;
        }
        return types;
    }

    public IType[] getSupertypes(IType type) {
        IType superclass = this.getSuperclass(type);
        if (superclass == null) {
            return this.getSuperModules(type);
        }
        TypeVector superTypes = new TypeVector(this.getSuperModules(type));
        superTypes.add(superclass);
        return superTypes.elements();
    }

    public IType getType() {
        return this.focusType;
    }

    protected IType[] growAndAddToArray(IType[] array, IType[] additions) {
        if (array == null || array.length == 0) {
            return additions;
        }
        IType[] old = array;
        array = new IType[old.length + additions.length];
        System.arraycopy(old, 0, array, 0, old.length);
        System.arraycopy(additions, 0, array, old.length, additions.length);
        return array;
    }

    protected IType[] growAndAddToArray(IType[] array, IType addition) {
        if (array == null || array.length == 0) {
            return new IType[]{addition};
        }
        IType[] old = array;
        array = new IType[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    public boolean hasFineGrainChanges() {
        ChangeCollector collector = this.changeCollector;
        return collector != null && collector.needsRefresh();
    }

    private boolean hasSubtypeNamed(String simpleName) {
        if (this.focusType != null && this.focusType.getElementName().equals(simpleName)) {
            return true;
        }
        IType[] types = this.focusType == null ? this.getAllTypes() : this.getAllSubtypes(this.focusType);
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeNamed(String simpleName) {
        IType[] types = this.getAllTypes();
        int i = 0;
        int length = types.length;
        while (i < length) {
            if (types[i].getElementName().equals(simpleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean includesTypeOrSupertype(IType type) {
        try {
            int lastSeparator;
            String simpleName;
            if (this.hasTypeNamed(type.getElementName())) {
                return true;
            }
            String superclassName = type.getSuperclassName();
            if (superclassName != null && this.hasTypeNamed(simpleName = superclassName.substring((lastSeparator = superclassName.lastIndexOf(46)) + 1))) {
                return true;
            }
            String[] superinterfaceNames = type.getIncludedModuleNames();
            if (superinterfaceNames == null) return false;
            int i = 0;
            int length = superinterfaceNames.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                String superinterfaceName = superinterfaceNames[i];
                int lastSeparator2 = superinterfaceName.lastIndexOf(46);
                String simpleName2 = superinterfaceName.substring(lastSeparator2 + 1);
                if (this.hasTypeNamed(simpleName2)) {
                    return true;
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return false;
    }

    protected void initialize(int size) {
        if (size < 10) {
            size = 10;
        }
        int smallSize = size / 2;
        this.classToSuperclass = new HashMap(size);
        this.modules = new ArrayList(smallSize);
        this.missingTypes = new ArrayList(smallSize);
        this.rootClasses = new TypeVector();
        this.typeToSubtypes = new HashMap(smallSize);
        this.typeToSuperModules = new HashMap(smallSize);
        this.typeFlags = new HashMap(smallSize);
        this.projectRegion = new Region();
        this.packageRegion = new Region();
        this.files = new HashMap(5);
    }

    public synchronized boolean isAffected(IRubyElementDelta delta) {
        IRubyElement element = delta.getElement();
        switch (element.getElementType()) {
            case 0: {
                return this.isAffectedByRubyModel(delta, element);
            }
            case 1: {
                return this.isAffectedByRubyProject(delta, element);
            }
            case 2: {
                return this.isAffectedBySourceFolderRoot(delta, element);
            }
            case 3: {
                return this.isAffectedBySourceFolder(delta, (SourceFolder)element);
            }
            case 4: {
                return this.isAffectedByOpenable(delta, element);
            }
        }
        return false;
    }

    private boolean isAffectedByChildren(IRubyElementDelta delta) {
        if ((delta.getFlags() & 8) > 0) {
            IRubyElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.isAffected(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isAffectedByRubyModel(IRubyElementDelta delta, IRubyElement element) {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                return element.equals(this.rubyProject().getRubyModel());
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isAffectedByRubyProject(IRubyElementDelta delta, IRubyElement element) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if ((flags & 0x200) != 0) {
            kind = 1;
        }
        if ((flags & 0x400) != 0) {
            kind = 2;
        }
        switch (kind) {
            case 1: {
                try {
                    ILoadpathEntry[] classpath = ((RubyProject)this.rubyProject()).getExpandedLoadpath(true);
                    int i = 0;
                    while (i < classpath.length) {
                        if (classpath[i].getEntryKind() == 2 && classpath[i].getPath().equals((Object)element.getPath())) {
                            return true;
                        }
                        ++i;
                    }
                    if (this.focusType != null) {
                        classpath = ((RubyProject)element).getExpandedLoadpath(true);
                        IPath hierarchyProject = this.rubyProject().getPath();
                        int i2 = 0;
                        while (i2 < classpath.length) {
                            if (classpath[i2].getEntryKind() == 2 && classpath[i2].getPath().equals((Object)hierarchyProject)) {
                                return true;
                            }
                            ++i2;
                        }
                    }
                    return false;
                }
                catch (RubyModelException rubyModelException) {
                    return false;
                }
            }
            case 2: {
                IRubyElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    IRubyProject javaProject = pkgs[i].getRubyProject();
                    if (javaProject != null && javaProject.equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    private boolean isAffectedBySourceFolder(IRubyElementDelta delta, SourceFolder element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: {
                return this.packageRegionContainsSameSourceFolder(element);
            }
            case 4: {
                return this.isAffectedByChildren(delta);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAffectedBySourceFolderRoot(IRubyElementDelta delta, IRubyElement element) {
        switch (delta.getKind()) {
            case 1: {
                return this.projectRegion.contains(element);
            }
            case 2: 
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x40) > 0 && this.projectRegion != null) {
                    ISourceFolderRoot root = (ISourceFolderRoot)element;
                    IPath rootPath = root.getPath();
                    IRubyElement[] elements = this.projectRegion.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        RubyProject javaProject = (RubyProject)elements[i];
                        try {
                            ILoadpathEntry[] classpath = javaProject.getResolvedLoadpath(true, false, false);
                            int j = 0;
                            while (j < classpath.length) {
                                ILoadpathEntry entry = classpath[j];
                                if (entry.getPath().equals((Object)rootPath)) {
                                    return true;
                                }
                                ++j;
                            }
                        }
                        catch (RubyModelException rubyModelException) {}
                        ++i;
                    }
                }
                if ((flags & 0x80) <= 0 && (flags & 1) <= 0) break;
                IRubyElement[] pkgs = this.packageRegion.getElements();
                int i = 0;
                while (i < pkgs.length) {
                    if (pkgs[i].getParent().equals(element)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return this.isAffectedByChildren(delta);
    }

    protected boolean isAffectedByOpenable(IRubyElementDelta delta, IRubyElement element) {
        if (element instanceof RubyScript) {
            ChangeCollector collector;
            RubyScript cu;
            block5: {
                cu = (RubyScript)element;
                collector = this.changeCollector;
                if (collector == null) {
                    collector = new ChangeCollector(this);
                }
                try {
                    collector.addChange(cu, delta);
                }
                catch (RubyModelException e) {
                    if (!DEBUG) break block5;
                    e.printStackTrace();
                }
            }
            if (cu.isWorkingCopy()) {
                this.changeCollector = collector;
                return false;
            }
            return collector.needsRefresh();
        }
        return false;
    }

    private boolean isModule(IType type) {
        return type.isModule();
    }

    public IRubyProject rubyProject() {
        return this.focusType.getRubyProject();
    }

    protected static byte[] readUntil(InputStream input, byte separator) throws RubyModelException, IOException {
        return TypeHierarchy.readUntil(input, separator, 0);
    }

    protected static byte[] readUntil(InputStream input, byte separator, int offset) throws IOException, RubyModelException {
        byte b;
        int length = 0;
        byte[] bytes = new byte[10];
        while ((b = (byte)input.read()) != separator && b != -1) {
            if (bytes.length == length) {
                byte[] byArray = bytes;
                bytes = new byte[length * 2];
                System.arraycopy(byArray, 0, bytes, 0, length);
            }
            bytes[length++] = b;
        }
        if (b == -1) {
            throw new RubyModelException(new RubyModelStatus(4));
        }
        byte[] byArray = bytes;
        bytes = new byte[length + offset];
        System.arraycopy(byArray, 0, bytes, offset, length);
        return bytes;
    }

    public static ITypeHierarchy load(IType type, InputStream input, WorkingCopyOwner owner) throws RubyModelException {
        try {
            byte[] missing;
            byte b;
            byte[] bytes;
            TypeHierarchy typeHierarchy = new TypeHierarchy();
            typeHierarchy.initialize(1);
            IType[] types = new IType[10];
            int typeCount = 0;
            byte version = (byte)input.read();
            if (version != 0) {
                throw new RubyModelException(new RubyModelStatus(4));
            }
            byte generalInfo = (byte)input.read();
            if ((generalInfo & 1) != 0) {
                typeHierarchy.computeSubtypes = true;
            }
            if ((bytes = TypeHierarchy.readUntil(input, (byte)10)).length > 0) {
                typeHierarchy.project = (IRubyProject)RubyCore.create(new String(bytes));
                typeHierarchy.scope = SearchEngine.createRubySearchScope(new IRubyElement[]{typeHierarchy.project});
            } else {
                typeHierarchy.project = null;
                typeHierarchy.scope = SearchEngine.createWorkspaceScope();
            }
            bytes = TypeHierarchy.readUntil(input, (byte)10);
            int j = 0;
            int length = bytes.length;
            int i = 0;
            while (i < length) {
                b = bytes[i];
                if (b == 44) {
                    missing = new byte[i - j];
                    System.arraycopy(bytes, j, missing, 0, i - j);
                    typeHierarchy.missingTypes.add(new String(missing));
                    j = i + 1;
                }
                ++i;
            }
            missing = new byte[length - j];
            System.arraycopy(bytes, j, missing, 0, length - j);
            typeHierarchy.missingTypes.add(new String(missing));
            while ((b = (byte)input.read()) != 10 && b != -1) {
                byte info;
                bytes = TypeHierarchy.readUntil(input, (byte)13, 1);
                bytes[0] = b;
                IType element = (IType)RubyCore.create(new String(bytes), owner);
                if (types.length == typeCount) {
                    IType[] iTypeArray = types;
                    types = new IType[typeCount * 2];
                    System.arraycopy(iTypeArray, 0, types, 0, typeCount);
                }
                types[typeCount++] = element;
                bytes = TypeHierarchy.readUntil(input, (byte)13);
                Integer flags = TypeHierarchy.bytesToFlags(bytes);
                if (flags != null) {
                    typeHierarchy.cacheFlags(element, flags);
                }
                if (((info = (byte)input.read()) & 1) != 0) {
                    typeHierarchy.addModule(element);
                }
                if ((info & 2) != 0) {
                    if (!element.equals(type)) {
                        throw new RubyModelException(new RubyModelStatus(4));
                    }
                    typeHierarchy.focusType = element;
                }
                if ((info & 4) == 0) continue;
                typeHierarchy.addRootClass(element);
            }
            while ((b = (byte)input.read()) != 10 && b != -1) {
                bytes = TypeHierarchy.readUntil(input, (byte)62, 1);
                bytes[0] = b;
                int subClass = new Integer(new String(bytes));
                bytes = TypeHierarchy.readUntil(input, (byte)10);
                int superClass = new Integer(new String(bytes));
                typeHierarchy.cacheSuperclass(types[subClass], types[superClass]);
            }
            while ((b = (byte)input.read()) != 10 && b != -1) {
                byte[] b2;
                bytes = TypeHierarchy.readUntil(input, (byte)62, 1);
                bytes[0] = b;
                int subClass = new Integer(new String(bytes));
                bytes = TypeHierarchy.readUntil(input, (byte)10);
                IType[] superInterfaces = new IType[bytes.length / 2 + 1];
                int interfaceCount = 0;
                int j2 = 0;
                int i2 = 0;
                while (i2 < bytes.length) {
                    if (bytes[i2] == 44) {
                        b2 = new byte[i2 - j2];
                        System.arraycopy(bytes, j2, b2, 0, i2 - j2);
                        j2 = i2 + 1;
                        superInterfaces[interfaceCount++] = types[new Integer(new String(b2))];
                    }
                    ++i2;
                }
                b2 = new byte[bytes.length - j2];
                System.arraycopy(bytes, j2, b2, 0, bytes.length - j2);
                superInterfaces[interfaceCount++] = types[new Integer(new String(b2))];
                IType[] iTypeArray = superInterfaces;
                superInterfaces = new IType[interfaceCount];
                System.arraycopy(iTypeArray, 0, superInterfaces, 0, interfaceCount);
                typeHierarchy.cacheSuperModules(types[subClass], superInterfaces);
            }
            if (b == -1) {
                throw new RubyModelException(new RubyModelStatus(4));
            }
            return typeHierarchy;
        }
        catch (IOException e) {
            throw new RubyModelException(e, 985);
        }
    }

    protected boolean packageRegionContainsSameSourceFolder(SourceFolder element) {
        IRubyElement[] pkgs = this.packageRegion.getElements();
        int i = 0;
        while (i < pkgs.length) {
            SourceFolder pkg = (SourceFolder)pkgs[i];
            if (Util.equalArraysOrNull(pkg.names, element.names)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void refresh(IProgressMonitor monitor) throws RubyModelException {
        try {
            try {
                this.progressMonitor = monitor;
                if (monitor != null) {
                    if (this.focusType != null) {
                        monitor.beginTask(Messages.bind(Messages.hierarchy_creatingOnType, this.focusType.getFullyQualifiedName()), 100);
                    } else {
                        monitor.beginTask(Messages.hierarchy_creating, 100);
                    }
                }
                long start = -1L;
                if (DEBUG) {
                    start = System.currentTimeMillis();
                    if (this.computeSubtypes) {
                        System.out.println("CREATING TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    } else {
                        System.out.println("CREATING SUPER TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    }
                    if (this.focusType != null) {
                        System.out.println("  on type " + ((RubyElement)((Object)this.focusType)).toStringWithAncestors());
                    }
                }
                this.compute();
                this.initializeRegions();
                this.needsRefresh = false;
                this.changeCollector = null;
                if (DEBUG) {
                    if (this.computeSubtypes) {
                        System.out.println("CREATED TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        System.out.println("CREATED SUPER TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    System.out.println(this.toString());
                }
            }
            catch (RubyModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new RubyModelException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            this.progressMonitor = null;
        }
    }

    public synchronized void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList listeners = this.changeListeners;
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            RubyCore.removeElementChangedListener(this);
        }
    }

    public void store(OutputStream output, IProgressMonitor monitor) throws RubyModelException {
        try {
            IRubyElement key;
            Integer index;
            Object t;
            Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
            Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>();
            int count = 0;
            if (this.focusType != null) {
                Integer index2 = new Integer(count++);
                hashtable.put(this.focusType, index2);
                hashtable2.put(index2, this.focusType);
            }
            Object[] types = this.classToSuperclass.keySet().toArray();
            int i = 0;
            while (i < types.length) {
                Object superClass;
                t = types[i];
                if (hashtable.get(t) == null) {
                    index = new Integer(count++);
                    hashtable.put(t, index);
                    hashtable2.put(index, t);
                }
                if ((superClass = this.classToSuperclass.get(t)) != null && hashtable.get(superClass) == null) {
                    Integer index3 = new Integer(count++);
                    hashtable.put(superClass, index3);
                    hashtable2.put(index3, superClass);
                }
                ++i;
            }
            types = this.typeToSuperModules.keySet().toArray();
            i = 0;
            while (i < types.length) {
                Object[] sp;
                t = types[i];
                if (hashtable.get(t) == null) {
                    index = new Integer(count++);
                    hashtable.put(t, index);
                    hashtable2.put(index, t);
                }
                if ((sp = (Object[])this.typeToSuperModules.get(t)) != null) {
                    int j = 0;
                    while (j < sp.length) {
                        Object superInterface = sp[j];
                        if (sp[j] != null && hashtable.get(superInterface) == null) {
                            Integer index4 = new Integer(count++);
                            hashtable.put(superInterface, index4);
                            hashtable2.put(index4, superInterface);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            output.write(0);
            int generalInfo = 0;
            if (this.computeSubtypes) {
                generalInfo = (byte)(generalInfo | 1);
            }
            output.write(generalInfo);
            if (this.project != null) {
                output.write(this.project.getHandleIdentifier().getBytes());
            }
            output.write(10);
            int i2 = 0;
            while (i2 < this.missingTypes.size()) {
                if (i2 != 0) {
                    output.write(44);
                }
                output.write(((String)this.missingTypes.get(i2)).getBytes());
                ++i2;
            }
            output.write(10);
            i2 = 0;
            while (i2 < count) {
                IType t2 = (IType)hashtable2.get(new Integer(i2));
                output.write(t2.getHandleIdentifier().getBytes());
                output.write(13);
                output.write(TypeHierarchy.flagsToBytes((Integer)this.typeFlags.get(t2)));
                output.write(13);
                int info = 0;
                if (this.focusType != null && this.focusType.equals(t2)) {
                    info = (byte)(info | 2);
                }
                if (this.modules.contains(t2)) {
                    info = (byte)(info | 1);
                }
                if (this.rootClasses.contains(t2)) {
                    info = (byte)(info | 4);
                }
                output.write(info);
                ++i2;
            }
            output.write(10);
            types = this.classToSuperclass.keySet().toArray();
            i2 = 0;
            while (i2 < types.length) {
                key = (IRubyElement)types[i2];
                IRubyElement value = (IRubyElement)this.classToSuperclass.get(key);
                output.write(((Integer)hashtable.get(key)).toString().getBytes());
                output.write(62);
                output.write(((Integer)hashtable.get(value)).toString().getBytes());
                output.write(10);
                ++i2;
            }
            output.write(10);
            types = this.typeToSuperModules.keySet().toArray();
            i2 = 0;
            while (i2 < types.length) {
                key = (IRubyElement)types[i2];
                IRubyElement[] values = (IRubyElement[])this.typeToSuperModules.get(key);
                if (values.length > 0) {
                    output.write(((Integer)hashtable.get(key)).toString().getBytes());
                    output.write(62);
                    int j = 0;
                    while (j < values.length) {
                        IRubyElement value = values[j];
                        if (j != 0) {
                            output.write(44);
                        }
                        output.write(((Integer)hashtable.get(value)).toString().getBytes());
                        ++j;
                    }
                    output.write(10);
                }
                ++i2;
            }
            output.write(10);
        }
        catch (IOException e) {
            throw new RubyModelException(e, 985);
        }
    }

    boolean subtypesIncludeSupertypeOf(IType type) {
        String simpleSuper;
        String superclassName = null;
        try {
            superclassName = type.getSuperclassName();
        }
        catch (RubyModelException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        if (superclassName == null) {
            superclassName = "Object";
        }
        int dot = -1;
        dot = superclassName.lastIndexOf(46);
        String string = simpleSuper = dot > -1 ? superclassName.substring(dot + 1) : superclassName;
        if (this.hasSubtypeNamed(simpleSuper)) {
            return true;
        }
        String[] interfaceNames = null;
        try {
            interfaceNames = type.getIncludedModuleNames();
        }
        catch (RubyModelException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        int i = 0;
        int length = interfaceNames.length;
        while (i < length) {
            String simpleInterface;
            dot = -1;
            String interfaceName = interfaceNames[i];
            dot = interfaceName.lastIndexOf(46);
            String string2 = simpleInterface = dot > -1 ? interfaceName.substring(dot) : interfaceName;
            if (this.hasSubtypeNamed(simpleInterface)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Focus: ");
        buffer.append(this.focusType == null ? "<NONE>" : ((RubyElement)((Object)this.focusType)).toStringWithAncestors(false));
        buffer.append("\n");
        if (this.exists()) {
            int i;
            IRubyElement[] roots;
            if (this.focusType != null) {
                buffer.append("Super types:\n");
                this.toString(buffer, this.focusType, 1, true);
                buffer.append("Sub types:\n");
                this.toString(buffer, this.focusType, 1, false);
            } else {
                buffer.append("Sub types of root classes:\n");
                roots = Util.sortCopy(this.getRootClasses());
                i = 0;
                while (i < roots.length) {
                    this.toString(buffer, (IType)roots[i], 1, false);
                    ++i;
                }
            }
            if (this.rootClasses.size > 1) {
                buffer.append("Root classes:\n");
                roots = Util.sortCopy(this.getRootClasses());
                i = 0;
                int length = roots.length;
                while (i < length) {
                    this.toString(buffer, (IType)roots[i], 1, false);
                    ++i;
                }
            } else if (this.rootClasses.size == 0) {
                buffer.append("No root classes");
            }
        } else {
            buffer.append("(Hierarchy became stale)");
        }
        return buffer.toString();
    }

    private void toString(StringBuffer buffer, IType type, int indent, boolean ascendant) {
        IRubyElement[] types = ascendant ? this.getSupertypes(type) : this.getSubtypes(type);
        IRubyElement[] sortedTypes = Util.sortCopy(types);
        int i = 0;
        while (i < sortedTypes.length) {
            int j = 0;
            while (j < indent) {
                buffer.append("  ");
                ++j;
            }
            RubyElement element = (RubyElement)sortedTypes[i];
            buffer.append(element.toStringWithAncestors(false));
            buffer.append('\n');
            this.toString(buffer, (IType)types[i], indent + 1, ascendant);
            ++i;
        }
    }

    boolean hasSupertype(String simpleName) {
        for (IType superType : this.classToSuperclass.values()) {
            if (!superType.getElementName().equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    protected void worked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
            this.checkCanceled();
        }
    }
}

