/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.internal.core.parser.IgnoreMarker;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreMarkersContentHandler
implements ContentHandler {
    public static final String ID = "id";
    public static final String OFFSET = "offset";
    public static final String END_OFFSET = "end";
    public static final String RESOURCE = "resource";
    public static final String WARNING = "warning";
    public static final String ROOT = "warnings";
    private StringBuffer data;
    private Collection<IgnoreMarker> markers;
    private int id;
    private int offset;
    private int endOffset;
    private IResource resource;

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.markers = new ArrayList<IgnoreMarker>();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = start;
        while (i < start + length) {
            this.data.append(ch[i]);
            ++i;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals(RESOURCE)) {
            IPath proj = Path.fromPortableString((String)this.data.toString());
            this.resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(proj);
        } else if (qName.equals(ID)) {
            this.id = Integer.parseInt(this.data.toString());
        } else if (qName.equals(OFFSET)) {
            this.offset = Integer.parseInt(this.data.toString());
        } else if (qName.equals(END_OFFSET)) {
            this.endOffset = Integer.parseInt(this.data.toString());
        } else if (qName.equals(WARNING) && this.resource != null) {
            this.markers.add(new IgnoreMarker(this.resource, this.id, this.offset, this.endOffset));
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.data = new StringBuffer();
    }

    public Collection<IgnoreMarker> getIgnoreMarkers() {
        return this.markers;
    }
}

