/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.compiler.IProblem;
import org.rubypeople.rdt.internal.core.parser.IgnoreMarker;
import org.rubypeople.rdt.internal.core.parser.IgnoreMarkersContentHandler;
import org.rubypeople.rdt.internal.core.parser.TaskTag;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerUtility {
    private static Set<IgnoreMarker> toIgnore = new HashSet<IgnoreMarker>();

    static {
        MarkerUtility.loadIgnoredMarkers();
    }

    public static void createSyntaxError(IResource underlyingResource, SyntaxException syntaxException) {
        try {
            ISourcePosition pos = syntaxException.getPosition();
            IMarker marker = underlyingResource.createMarker("org.rubypeople.rdt.core.problem");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", new Integer(2));
            map.put("message", "Syntax Error");
            map.put("userEditable", Boolean.FALSE);
            map.put("lineNumber", new Integer(pos.getStartLine()));
            map.put("charStart", new Integer(pos.getStartOffset()));
            map.put("charEnd", new Integer(pos.getEndOffset()));
            map.put("id", 0x40000000);
            marker.setAttributes(map);
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    public static void removeMarkers(IResource underlyingResource) {
        try {
            underlyingResource.deleteMarkers("org.rubypeople.rdt.core.problem", true, 2);
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    public static void createProblemMarkers(IResource resource, List<IProblem> problems) {
        Iterator<IProblem> iter = problems.iterator();
        while (iter.hasNext()) {
            MarkerUtility.createProblemMarker(resource, iter.next());
        }
    }

    public static void createProblemMarker(IResource underlyingResource, IProblem problem) {
        if (problem.isTask()) {
            try {
                MarkerUtility.createTask(underlyingResource, (TaskTag)problem);
            }
            catch (CoreException e) {
                RubyCore.log((Exception)((Object)e));
            }
            return;
        }
        try {
            if (MarkerUtility.markerExists(underlyingResource, problem.getID(), problem.getSourceStart(), problem.getSourceEnd(), "org.rubypeople.rdt.core.problem")) {
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            int severity = problem.isWarning() ? 1 : (problem.isError() ? 2 : 0);
            IMarker marker = underlyingResource.createMarker("org.rubypeople.rdt.core.problem");
            map.put("severity", new Integer(severity));
            map.put("message", problem.getMessage());
            map.put("userEditable", Boolean.FALSE);
            map.put("lineNumber", new Integer(problem.getSourceLineNumber()));
            map.put("charStart", new Integer(problem.getSourceStart()));
            map.put("charEnd", new Integer(problem.getSourceEnd()));
            map.put("id", problem.getID());
            marker.setAttributes(map);
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    public static void createTasks(IResource underlyingResource, List<TaskTag> tasks) throws CoreException {
        Iterator<TaskTag> iter = tasks.iterator();
        while (iter.hasNext()) {
            MarkerUtility.createTask(underlyingResource, iter.next());
        }
    }

    private static void createTask(IResource resource, TaskTag task) throws CoreException {
        int lineNumber = task.getSourceLineNumber();
        if (lineNumber <= 0) {
            lineNumber = 1;
        }
        if (MarkerUtility.markerExists(resource, task.getID(), task.getSourceStart(), task.getSourceEnd(), "org.rubypeople.rdt.core.task")) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("priority", new Integer(task.getPriority()));
        map.put("message", task.getMessage());
        map.put("lineNumber", new Integer(lineNumber));
        map.put("severity", new Integer(0));
        map.put("userEditable", new Boolean(false));
        map.put("transient", new Boolean(false));
        map.put("charStart", new Integer(task.getSourceStart()));
        map.put("charEnd", new Integer(task.getSourceEnd()));
        map.put("id", task.getID());
        IMarker marker = resource.createMarker("org.rubypeople.rdt.core.task");
        marker.setAttributes(map);
    }

    public static boolean markerExists(IResource resource, int id, int offset, int endOffset, String type) throws CoreException {
        if (MarkerUtility.ignoring(resource, id, offset, endOffset)) {
            return true;
        }
        IMarker[] tasks = resource.findMarkers(type, true, 0);
        int i = 0;
        while (i < tasks.length) {
            if (MarkerUtility.markerMatches(id, offset, endOffset, tasks[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean ignoring(IResource resource, int id, int offset, int endOffset) {
        for (IgnoreMarker marker : toIgnore) {
            if (!marker.getResource().equals((Object)resource) || !MarkerUtility.markerMatches(id, offset, endOffset, marker)) continue;
            return true;
        }
        return false;
    }

    private static boolean markerMatches(int id, int offset, int endOffset, IgnoreMarker marker) {
        if (marker.getId() != id) {
            return false;
        }
        if (marker.getOffset() != offset) {
            return false;
        }
        return marker.getEndOffset() == endOffset;
    }

    public static boolean markerMatches(int id, int offset, int endOffset, IMarker marker) throws CoreException {
        Integer markerId = (Integer)marker.getAttribute("id");
        if (markerId != id) {
            return false;
        }
        Integer start = (Integer)marker.getAttribute("charStart");
        if (start != offset) {
            return false;
        }
        Integer end = (Integer)marker.getAttribute("charEnd");
        return end == endOffset;
    }

    public static void ignore(IResource resource, int problemId, int offset, int length) {
        MarkerUtility.ignore(new IgnoreMarker(resource, problemId, offset, offset + length));
    }

    public static void ignore(IMarker marker) {
        try {
            MarkerUtility.ignore(new IgnoreMarker(marker));
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    public static synchronized void ignore(IgnoreMarker marker) {
        if (toIgnore.contains(marker)) {
            return;
        }
        toIgnore.add(marker);
        MarkerUtility.saveIgnoredMarkers();
    }

    private static void saveIgnoredMarkers() {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(MarkerUtility.getConfigFile()));
                MarkerUtility.writeXML(out);
            }
            catch (FileNotFoundException e) {
                RubyCore.log(e);
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                RubyCore.log(e);
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void loadIgnoredMarkers() {
        block19: {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(MarkerUtility.getConfigFile());
                XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                IgnoreMarkersContentHandler handler = new IgnoreMarkersContentHandler();
                reader.setContentHandler(handler);
                reader.parse(new InputSource(fileReader));
                toIgnore.clear();
                Collection<IgnoreMarker> markers = handler.getIgnoreMarkers();
                for (IgnoreMarker marker : markers) {
                    toIgnore.add(marker);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (fileReader != null) {
                        ((Reader)fileReader).close();
                    }
                    break block19;
                }
                catch (IOException iOException) {}
                break block19;
            }
            catch (Exception e) {
                try {
                    RubyCore.log(e);
                }
                catch (Throwable throwable) {
                    try {
                        if (fileReader != null) {
                            ((Reader)fileReader).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (fileReader != null) {
                        ((Reader)fileReader).close();
                    }
                    break block19;
                }
                catch (IOException iOException) {}
                break block19;
            }
            try {
                if (fileReader != null) {
                    ((Reader)fileReader).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getConfigFile() {
        IPath rubyCoreMetadataDir = RubyCore.getPlugin().getStateLocation();
        return rubyCoreMetadataDir.append("ignore_warnings.xml").toFile();
    }

    private static void writeXML(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println(MarkerUtility.tag("warnings"));
        for (IgnoreMarker s : toIgnore) {
            out.println(MarkerUtility.tag("warning"));
            out.println(MarkerUtility.tag("resource", s.getResource().getLocation().toPortableString()));
            out.println(MarkerUtility.tag("id", s.getId()));
            out.println(MarkerUtility.tag("offset", s.getOffset()));
            out.println(MarkerUtility.tag("end", s.getEndOffset()));
            out.println(MarkerUtility.endTag("warning"));
        }
        out.println(MarkerUtility.endTag("warnings"));
        out.flush();
    }

    private static String tag(String tag) {
        return "<" + tag + ">";
    }

    private static String endTag(String tag) {
        return "</" + tag + ">";
    }

    private static String tag(String tag, String content) {
        return String.valueOf(MarkerUtility.tag(tag)) + content + MarkerUtility.endTag(tag);
    }

    private static String tag(String tag, int intValue) {
        return MarkerUtility.tag(tag, Integer.toString(intValue));
    }
}

