/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.core.parser.Error;
import org.rubypeople.rdt.internal.core.parser.Warning;
import org.rubypeople.rdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdtWarnings
implements IRubyWarnings {
    private List<CategorizedProblem> warnings;
    private String fileName;

    public RdtWarnings(String fileName) {
        this.fileName = fileName;
        this.warnings = new ArrayList<CategorizedProblem>();
    }

    public List<CategorizedProblem> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public void warn(IRubyWarnings.ID id, ISourcePosition position, String message, Object ... data) {
        if (Util.ignore(message)) {
            return;
        }
        if (message.equals("Statement not reached.")) {
            String value = RubyCore.getOption("org.rubypeople.rdt.core.compiler.problem.unreachableCode");
            if (value == null || value.equals("warning")) {
                this.warnings.add(new Warning(position, message));
            }
            if (value != null && value.equals("error")) {
                this.warnings.add(new Error(position, message));
            }
            return;
        }
        if (message.equals("parenthesize argument(s) for future version")) {
            IDESourcePosition pos = new IDESourcePosition(position.getFile(), position.getStartLine(), position.getEndLine(), position.getStartOffset(), position.getEndOffset() - 2);
            this.warnings.add(new Warning((ISourcePosition)pos, message, 0x40000002));
            return;
        }
        this.warnings.add(new Warning(position, message));
    }

    public void warn(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        this.warn(id, (ISourcePosition)new IDESourcePosition(fileName, lineNumber, lineNumber), message, data);
    }

    public boolean isVerbose() {
        return true;
    }

    public void warn(IRubyWarnings.ID id, String message, Object ... data) {
        this.warn(id, this.fileName, 1, message, data);
    }

    public void warning(IRubyWarnings.ID id, String message, Object ... data) {
        this.warning(id, this.fileName, 1, message, data);
    }

    public void warning(IRubyWarnings.ID id, ISourcePosition position, String message, Object ... data) {
        this.warning(id, position.getFile(), position.getEndLine(), message, data);
    }

    public void warning(IRubyWarnings.ID id, String fileName, int lineNumber, String message, Object ... data) {
        if (this.isVerbose()) {
            this.warn(id, fileName, lineNumber, message, data);
        }
    }
}

