/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.parser.TaskTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskParser {
    private boolean fCaseSensitive = false;
    private String[] fTags;
    private int[] fPriorities;
    private List<TaskTag> tasks;

    public TaskParser(Map preferences) {
        String caseSensitive = this.getString(preferences, "org.rubypeople.rdt.core.compiler.taskCaseSensitive", "enabled");
        if (caseSensitive.equals("enabled")) {
            this.fCaseSensitive = true;
        }
        String tags = this.getString(preferences, "org.rubypeople.rdt.core.compiler.taskTags", "TODO,FIXME,XXX,OPTIMIZE");
        String priorities = this.getString(preferences, "org.rubypeople.rdt.core.compiler.taskPriorities", "NORMAL,HIGH,NORMAL,NORMAL");
        this.fTags = this.tokenize(tags, ",");
        this.fPriorities = this.convertPriorities(this.tokenize(priorities, ","));
        this.tasks = new ArrayList<TaskTag>();
    }

    private String getString(Map preferences, String key, String def) {
        if (preferences == null) {
            return def;
        }
        String answer = (String)preferences.get(key);
        if (answer == null) {
            return def;
        }
        return answer;
    }

    private int[] convertPriorities(String[] stringPriorities) {
        int[] priorities = new int[stringPriorities.length];
        int i = 0;
        while (i < stringPriorities.length) {
            String priority = stringPriorities[i];
            priorities[i] = priority.equals("LOW") ? 0 : (priority.equals("HIGH") ? 2 : 1);
            ++i;
        }
        return priorities;
    }

    private String[] tokenize(String tags, String delim) {
        StringTokenizer tokenizer = new StringTokenizer(tags, delim);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            tokens[i++] = tokenizer.nextToken();
        }
        return tokens;
    }

    public void parse(Reader reader) throws IOException {
        String loadFromReader = this.loadFromReader(reader);
        this.parse(loadFromReader);
    }

    public void parse(String contents) {
        try {
            if (this.fTags.length <= 0) {
                return;
            }
            int offset = 0;
            int lineNum = 0;
            String line = null;
            while ((line = this.findNextLine(contents, offset)) != null) {
                this.processLine(line, offset, lineNum);
                ++lineNum;
                offset += line.length();
            }
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    private String findNextLine(String contents, int offset) {
        if (offset >= contents.length()) {
            return null;
        }
        int crPos = contents.indexOf(13, offset);
        int nlPos = contents.indexOf(10, offset);
        int eolPos = crPos;
        if (crPos == -1) {
            eolPos = nlPos;
        }
        if (nlPos == -1 && crPos == -1) {
            return contents.substring(offset);
        }
        if (crPos + 1 == nlPos && crPos >= 0) {
            ++eolPos;
        }
        return contents.substring(offset, eolPos + 1);
    }

    private void processLine(String line, int offset, int lineNum) throws CoreException {
        if (!this.fCaseSensitive) {
            line = line.toLowerCase();
        }
        int i = 0;
        while (i < this.fTags.length) {
            String tag = this.fTags[i];
            int priority = this.fPriorities[i];
            if (!this.fCaseSensitive) {
                tag = tag.toLowerCase();
            }
            if (line.matches(".*#.*" + tag + ".*[\\n\\r]*")) {
                int index = line.indexOf(tag);
                String message = line.substring(index).trim();
                this.createTaskTag(priority, message, lineNum + 1, offset + index, offset + index + message.length());
            }
            ++i;
        }
    }

    private void createTaskTag(int priority, String message, int lineNumber, int start, int end) throws CoreException {
        TaskTag task = new TaskTag(message, priority, lineNumber, start, end);
        this.tasks.add(task);
    }

    private String loadFromReader(Reader reader) throws IOException {
        StringBuffer contents = new StringBuffer();
        char[] buffer = new char[4096];
        int bytesRead;
        while ((bytesRead = reader.read(buffer)) != -1) {
            contents.append(buffer, 0, bytesRead);
        }
        return contents.toString();
    }

    public List<TaskTag> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public void clear() {
        this.tasks.clear();
    }
}

