/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser.warnings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class CoreClassReOpening
extends RubyLintVisitor {
    private List<Node> typeStack;
    private RootNode rootNode;
    private IRubyScript script;
    private static Set<String> coreTypes = new HashSet<String>();

    static {
        coreTypes.add("Array");
        coreTypes.add("Bignum");
        coreTypes.add("Class");
        coreTypes.add("Complex");
        coreTypes.add("Date");
        coreTypes.add("DateTime");
        coreTypes.add("Enumerable");
        coreTypes.add("FalseClass");
        coreTypes.add("Fixnum");
        coreTypes.add("Float");
        coreTypes.add("NilClass");
        coreTypes.add("Numeric");
        coreTypes.add("Rational");
        coreTypes.add("Regexp");
        coreTypes.add("Set");
        coreTypes.add("String");
        coreTypes.add("Time");
        coreTypes.add("TrueClass");
    }

    public CoreClassReOpening(IRubyScript script, String contents) {
        super(contents);
        this.script = script;
        this.typeStack = new ArrayList<Node>();
    }

    protected String getOptionKey() {
        return "org.rubypeople.rdt.core.compiler.problem.redefinition.core.class.method";
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        String methodName;
        String typeName = this.getCurrentTypeName();
        if (this.isCoreClass(typeName) && this.methodExistsOnType(typeName, methodName = iVisited.getName())) {
            this.createProblem(iVisited.getPosition(), "Redefinition of a Ruby Core class method is dangerous");
        }
        return super.visitDefnNode(iVisited);
    }

    private boolean methodExistsOnType(String typeName, String methodName) {
        IType type = this.getType(typeName);
        if (type == null) {
            return false;
        }
        try {
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            SearchEngine engine = new SearchEngine();
            IRubySearchScope scope = SearchEngine.createRubySearchScope(new IRubyElement[]{type});
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            SearchPattern pattern = SearchPattern.createPattern(6, methodName, 0, 0);
            engine.search(pattern, participants, scope, requestor, null);
            List<SearchMatch> matches = requestor.getResults();
            return matches != null && !matches.isEmpty();
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return false;
    }

    private IType getType(String typeName) {
        List<SearchMatch> matches;
        block4: {
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            SearchEngine engine = new SearchEngine();
            ISourceFolderRoot[] roots = this.script.getRubyProject().getAllSourceFolderRoots();
            ISourceFolderRoot stubs = this.findCoreStubsRoot(roots);
            IRubySearchScope scope = SearchEngine.createRubySearchScope(new IRubyElement[]{stubs});
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            SearchPattern pattern = SearchPattern.createPattern(5, typeName, 0, 0);
            engine.search(pattern, participants, scope, requestor, null);
            matches = requestor.getResults();
            if (matches != null && !matches.isEmpty()) break block4;
            return null;
        }
        try {
            return (IType)matches.get(0).getElement();
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return null;
    }

    private ISourceFolderRoot findCoreStubsRoot(ISourceFolderRoot[] roots) {
        int i = 0;
        while (i < roots.length) {
            String segment;
            ISourceFolderRoot root = roots[i];
            IPath path = root.getPath();
            if (path.segmentCount() >= 3 && (segment = path.segment(path.segmentCount() - 3)).equals("org.rubypeople.rdt.launching")) {
                return root;
            }
            ++i;
        }
        return null;
    }

    private boolean isCoreClass(String typeName) {
        return coreTypes.contains(typeName);
    }

    public Instruction visitRootNode(RootNode iVisited) {
        this.rootNode = iVisited;
        return super.visitRootNode(iVisited);
    }

    private String getCurrentTypeName() {
        Node typeNode = this.typeStack.get(this.typeStack.size() - 1);
        String typeName = ASTUtil.getFullyQualifiedTypeName((Node)this.rootNode, typeNode);
        return typeName;
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.push((Node)iVisited);
        return super.visitClassNode(iVisited);
    }

    public void exitClassNode(ClassNode iVisited) {
        this.pop();
        super.exitClassNode(iVisited);
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        this.push((Node)iVisited);
        return super.visitModuleNode(iVisited);
    }

    public void exitModuleNode(ModuleNode iVisited) {
        this.pop();
        super.exitModuleNode(iVisited);
    }

    private void pop() {
        this.typeStack.remove(this.typeStack.size() - 1);
    }

    private void push(Node visited) {
        this.typeStack.add(visited);
    }
}

