/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser.warnings;

import org.jruby.ast.Node;
import org.jruby.ast.WhenNode;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class Ruby19WhenStatements
extends RubyLintVisitor {
    public Ruby19WhenStatements(String contents) {
        super(contents);
    }

    protected String getOptionKey() {
        return "org.rubypeople.rdt.core.compiler.problem.ruby19WhenStatements";
    }

    public Instruction visitWhenNode(WhenNode iVisited) {
        if (iVisited.getExpressionNodes() == null) {
            return super.visitWhenNode(iVisited);
        }
        if (iVisited.getBodyNode() == null) {
            return super.visitWhenNode(iVisited);
        }
        if (iVisited.getPosition() == null) {
            return super.visitWhenNode(iVisited);
        }
        int start = iVisited.getPosition().getStartOffset();
        ISourcePosition pos = iVisited.getExpressionNodes().getPosition();
        if (pos == null) {
            return super.visitWhenNode(iVisited);
        }
        ISourcePosition bodyPosition = iVisited.getBodyNode().getPosition();
        if (bodyPosition == null) {
            return super.visitWhenNode(iVisited);
        }
        String src = this.getSource((Node)iVisited);
        if ((src = src.substring(pos.getEndOffset() - start, bodyPosition.getStartOffset() - start)).trim().equals(":")) {
            int startOffset = pos.getEndOffset() + src.indexOf(":");
            int endOffset = startOffset + 1;
            IDESourcePosition position = new IDESourcePosition("", pos.getEndLine(), pos.getEndLine(), startOffset, endOffset);
            this.createProblem((ISourcePosition)position, "':' not supported for when statements in Ruby 1.9. Please use 'then'.");
        }
        return super.visitWhenNode(iVisited);
    }

    protected String getSeverity() {
        return super.getSeverity();
    }

    protected int getProblemID() {
        return 0x40000004;
    }
}

