/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.pmd;

import java.util.List;
import org.rubypeople.rdt.internal.core.pmd.SourceCode;
import org.rubypeople.rdt.internal.core.pmd.TokenEntry;
import org.rubypeople.rdt.internal.core.pmd.Tokenizer;
import org.rubypeople.rdt.internal.core.pmd.Tokens;

public class RubyTokenizer
implements Tokenizer {
    private boolean downcaseString = true;

    public void tokenize(SourceCode tokens, Tokens tokenEntries) {
        List code = tokens.getCode();
        int curLineOffset = 0;
        int i = 0;
        while (i < code.size()) {
            String currentLine = (String)code.get(i);
            int loc = 0;
            int startOffset = 0;
            while (loc < currentLine.length()) {
                StringBuffer token = new StringBuffer();
                startOffset = curLineOffset + loc;
                loc = this.getTokenFromLine(currentLine, token, loc);
                if (token.length() <= 0 || this.isIgnorableString(token.toString())) continue;
                if (this.downcaseString) {
                    token = new StringBuffer(token.toString().toLowerCase());
                }
                tokenEntries.add(new TokenEntry(token.toString(), tokens.getFileName(), i + 1, startOffset, startOffset + token.length()));
            }
            curLineOffset += currentLine.length();
            ++i;
        }
        tokenEntries.add(TokenEntry.getEOF());
    }

    private int getTokenFromLine(String line, StringBuffer token, int loc) {
        int j = loc;
        while (j < line.length()) {
            char tok = line.charAt(j);
            if (!Character.isWhitespace(tok) && !this.ignoreCharacter(tok)) {
                if (this.isComment(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.getCommentToken(line, token, loc);
                }
                if (this.isString(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.parseString(line, token, j, tok);
                }
                token.append(tok);
            } else if (token.length() > 0) {
                return j;
            }
            loc = j++;
        }
        return loc + 1;
    }

    private int parseString(String line, StringBuffer token, int loc, char stringType) {
        boolean escaped = false;
        boolean done = false;
        char tok = ' ';
        while (loc < line.length() && !done) {
            tok = line.charAt(loc);
            if (escaped && tok == stringType) {
                escaped = false;
            } else if (tok == stringType && token.length() > 0) {
                done = true;
            } else {
                escaped = tok == '\\';
            }
            token.append(tok);
            ++loc;
        }
        return loc + 1;
    }

    private boolean ignoreCharacter(char tok) {
        boolean result = false;
        switch (tok) {
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '{': 
            case '}': {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean isString(char tok) {
        boolean result = false;
        switch (tok) {
            case '\"': 
            case '\'': {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean isComment(char tok) {
        return tok == '#';
    }

    private int getCommentToken(String line, StringBuffer token, int loc) {
        while (loc < line.length()) {
            token.append(line.charAt(loc));
            ++loc;
        }
        return loc;
    }

    private boolean isIgnorableString(String token) {
        return "do".equals(token) || "end".equals(token);
    }
}

