/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.HashtableOfArrayToObject;
import org.rubypeople.rdt.internal.core.util.Util;

public class HandleFactory {
    private String lastSrcFolderRootPath;
    private ISourceFolderRoot lastSrcFolderRoot;
    private HashtableOfArrayToObject folderHandles;
    private RubyModel rubyModel = RubyModelManager.getRubyModelManager().getRubyModel();

    private ISourceFolderRoot getSourceFolderRoot(String pathString) {
        Path path = new Path(pathString);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            try {
                IProject project = projects[i];
                if (project.isAccessible() && project.hasNature("org.rubypeople.rdt.core.rubynature")) {
                    IRubyProject rubyProject = this.rubyModel.getRubyProject((IResource)project);
                    ISourceFolderRoot[] roots = rubyProject.getSourceFolderRoots();
                    int j = 0;
                    int rootCount = roots.length;
                    while (j < rootCount) {
                        SourceFolderRoot root = (SourceFolderRoot)roots[j];
                        if (root.getPath().isPrefixOf((IPath)path) && !Util.isExcluded((IPath)path, root.fullInclusionPatternChars(), root.fullExclusionPatternChars(), false)) {
                            return root;
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    public Openable createOpenable(String resourcePath) {
        String simpleName;
        Object[] pkgName;
        String[] simpleNames;
        int length;
        int rootPathLength = -1;
        if (this.lastSrcFolderRootPath == null || !resourcePath.startsWith(this.lastSrcFolderRootPath) || (rootPathLength = this.lastSrcFolderRootPath.length()) <= 0 || resourcePath.charAt(rootPathLength) != '/') {
            ISourceFolderRoot root = this.getSourceFolderRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastSrcFolderRoot = root;
            this.lastSrcFolderRootPath = this.lastSrcFolderRoot.getPath().toString();
            this.folderHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(resourcePath = resourcePath.substring(this.lastSrcFolderRootPath.length() + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        ISourceFolder pkgFragment = (ISourceFolder)this.folderHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((SourceFolderRoot)this.lastSrcFolderRoot).getSourceFolder((String[])pkgName);
            this.folderHandles.put(pkgName, pkgFragment);
        }
        if (Util.isRubyOrERBLikeFileName(simpleName = simpleNames[length])) {
            IRubyScript unit = pkgFragment.getRubyScript(simpleName);
            return (Openable)((Object)unit);
        }
        return null;
    }
}

