/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.rubypeople.rdt.internal.core.util.Util;

public class MethodPatternParser {
    private String selector;
    private String typeName;
    List<String> params = new ArrayList<String>();

    public char[] getSelector() {
        if (this.selector == null) {
            return null;
        }
        return this.selector.toCharArray();
    }

    public void parse(String string) {
        if (string == null) {
            return;
        }
        int index = string.indexOf(".");
        if (index == -1) {
            index = string.indexOf("#");
        }
        if (index != -1) {
            this.typeName = string.substring(0, index);
            this.selector = string.substring(index + 1);
        } else {
            this.selector = string;
            this.typeName = null;
        }
        index = this.selector.indexOf(40);
        if (index != -1) {
            String raw = this.selector.substring(index + 1, this.selector.length() - 1);
            this.selector = this.selector.substring(0, index);
            StringTokenizer tokenizer = new StringTokenizer(raw, " ,");
            while (tokenizer.hasMoreTokens()) {
                String param = tokenizer.nextToken();
                this.params.add(param);
            }
        }
    }

    public char[] getTypeSimpleName() {
        if (this.typeName == null) {
            return null;
        }
        String name = Util.getSimpleName(this.typeName);
        if (name == null) {
            return null;
        }
        return name.toCharArray();
    }

    public char[] getQualifiedTypeName() {
        if (this.typeName == null) {
            return null;
        }
        return this.typeName.toCharArray();
    }

    public char[][] getParameterNames() {
        if (this.params.isEmpty()) {
            return null;
        }
        char[][] parameters = new char[this.params.size()][];
        int i = 0;
        for (String param : this.params) {
            parameters[i++] = param.toCharArray();
        }
        return parameters;
    }
}

