/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.SearchDocument;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.internal.core.search.processing.JobManager;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubySearchDocument
extends SearchDocument {
    private IFile file;
    protected char[] charContents;

    public RubySearchDocument(String documentPath, SearchParticipant participant) {
        super(documentPath, participant);
    }

    public RubySearchDocument(String documentPath, char[] contents, SearchParticipant participant) {
        this(documentPath, participant);
        this.charContents = contents;
    }

    public char[] getCharContents() {
        if (this.charContents != null) {
            return this.charContents;
        }
        try {
            return Util.getResourceContentsAsCharArray(this.getFile());
        }
        catch (RubyModelException e) {
            if (JobManager.VERBOSE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private IFile getFile() {
        if (this.file == null) {
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getPath()));
        }
        return this.file;
    }
}

