/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.indexing;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.search.SearchDocument;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.SourceElementParser;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.rubypeople.rdt.internal.core.search.matching.ConstructorPattern;
import org.rubypeople.rdt.internal.core.search.matching.FieldPattern;
import org.rubypeople.rdt.internal.core.search.matching.MethodPattern;
import org.rubypeople.rdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.rubypeople.rdt.internal.core.search.matching.TypeDeclarationPattern;
import org.rubypeople.rdt.internal.core.search.processing.JobManager;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class SourceIndexer
implements IIndexConstants {
    private SearchDocument document;

    public SourceIndexer(SearchDocument document) {
        this.document = document;
    }

    public void indexDocument() {
        block7: {
            SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
            String documentPath = this.document.getPath();
            SourceElementParser parser = this.document.parser;
            if (parser == null) {
                Path path = new Path(documentPath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                parser = RubyModelManager.getRubyModelManager().getIndexManager().getSourceElementParser(RubyCore.create(project), requestor);
            } else {
                parser.requestor = requestor;
            }
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {}
            if (source == null || name == null) {
                return;
            }
            try {
                parser.parse(source, name);
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block7;
                e.printStackTrace();
            }
        }
    }

    public void addClassDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[] superclass, char[][] superinterfaces, boolean secondary) {
        char[] indexKey = TypeDeclarationPattern.createIndexKey(modifiers, name, packageName, enclosingTypeNames, secondary);
        this.addIndexEntry(TYPE_DECL, indexKey);
        if (superclass != null && !superclass.equals("Object")) {
            this.addTypeReference(superclass);
        }
        this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'C', superclass, 'C'));
        if (superinterfaces != null) {
            int i = 0;
            int max = superinterfaces.length;
            while (i < max) {
                char[] superinterface = superinterfaces[i];
                this.addTypeReference(superinterface);
                this.addIncludedModuleReference(modifiers, packageName, name, enclosingTypeNames, superinterface);
                ++i;
            }
        }
    }

    public void addIncludedModuleReference(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[] superinterface) {
        this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'C', superinterface, 'M'));
    }

    public void addFieldDeclaration(char[] typeName, char[] fieldName) {
        this.addIndexEntry(FIELD_DECL, FieldPattern.createIndexKey(fieldName));
        if (typeName != null) {
            this.addTypeReference(typeName);
        }
    }

    public void addFieldReference(char[] fieldName) {
        this.addNameReference(fieldName);
    }

    public void addMethodDeclaration(char[] methodName, int arity) {
        this.addIndexEntry(METHOD_DECL, MethodPattern.createIndexKey(methodName, arity));
    }

    public void addMethodReference(char[] methodName, int argCount) {
        this.addIndexEntry(METHOD_REF, MethodPattern.createIndexKey(methodName, argCount));
    }

    public void addNameReference(char[] name) {
        this.addIndexEntry(REF, name);
    }

    public void addTypeReference(char[] typeName) {
        this.addNameReference(CharOperation.lastSegment(typeName, "::"));
    }

    protected void addIndexEntry(char[] category, char[] key) {
        this.document.addIndexEntry(category, key);
    }

    public void addConstructorDeclaration(char[] typeName, int argCount) {
        this.addIndexEntry(CONSTRUCTOR_DECL, ConstructorPattern.createIndexKey(CharOperation.lastSegment(typeName, "::"), argCount));
    }

    public void addConstructorReference(char[] typeName, int argCount) {
        char[] simpleTypeName = CharOperation.lastSegment(typeName, "::");
        this.addTypeReference(simpleTypeName);
        this.addIndexEntry(CONSTRUCTOR_REF, ConstructorPattern.createIndexKey(simpleTypeName, argCount));
    }
}

