/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.indexing;

import java.util.Stack;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.compiler.ISourceElementRequestor;
import org.rubypeople.rdt.internal.core.search.indexing.SourceIndexer;
import org.rubypeople.rdt.internal.core.util.Util;

public class SourceIndexerRequestor
implements ISourceElementRequestor {
    private SourceIndexer indexer;
    private Stack<ISourceElementRequestor.TypeInfo> typeStack;

    public SourceIndexerRequestor(SourceIndexer sourceIndexer) {
        this.indexer = sourceIndexer;
        this.typeStack = new Stack();
    }

    public void acceptConstructorReference(String name, int argCount, int offset) {
        this.indexer.addConstructorReference(name.toCharArray(), argCount);
    }

    public void acceptFieldReference(String name, int offset) {
        this.indexer.addFieldReference(name.toCharArray());
    }

    public void acceptImport(String value, int startOffset, int endOffset) {
    }

    public void acceptMethodReference(String name, int argCount, int offset) {
        this.indexer.addMethodReference(name.toCharArray(), argCount);
    }

    public void acceptMixin(String moduleName) {
        this.indexer.addTypeReference(moduleName.toCharArray());
        ISourceElementRequestor.TypeInfo info = this.typeStack.peek();
        char[] simpleName = this.getSimpleName(info.name);
        char[][] enclosingTypes = this.getEnclosingTypeNames(info.name);
        this.indexer.addIncludedModuleReference(info.isModule ? 1 : 0, new char[0], simpleName, enclosingTypes, moduleName.toCharArray());
    }

    public void acceptProblem(CategorizedProblem problem) {
    }

    public void acceptTypeReference(String name, int startOffset, int endOffset) {
        this.indexer.addTypeReference(name.toCharArray());
    }

    public void acceptUnknownReference(String name, int startOffset, int endOffset) {
    }

    public void enterConstructor(ISourceElementRequestor.MethodInfo constructor) {
        this.indexer.addConstructorDeclaration(constructor.name.toCharArray(), constructor.parameterNames.length);
    }

    public void enterField(ISourceElementRequestor.FieldInfo field) {
        this.indexer.addFieldDeclaration(null, field.name.toCharArray());
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo method) {
        this.indexer.addMethodDeclaration(method.name.toCharArray(), method.parameterNames.length);
    }

    public void enterScript() {
    }

    public void enterType(ISourceElementRequestor.TypeInfo type) {
        String[] modules = type.modules;
        char[][] mod = new char[modules.length][];
        int i = 0;
        while (i < modules.length) {
            mod[i] = modules[i].toCharArray();
            ++i;
        }
        char[] packName = new char[]{};
        char[] superclass = new char[]{};
        if (type.superclass != null) {
            superclass = type.superclass.toCharArray();
        }
        char[] simpleName = this.getSimpleName(type.name);
        char[][] enclosingTypes = this.getEnclosingTypeNames(type.name);
        this.indexer.addClassDeclaration(type.isModule ? 1 : 0, packName, simpleName, enclosingTypes, superclass, mod, type.secondary);
        this.typeStack.push(type);
    }

    private char[] getSimpleName(String name) {
        return Util.getSimpleName(name).toCharArray();
    }

    private char[][] getEnclosingTypeNames(String typeName) {
        String[] parts = typeName.split("::");
        char[][] names = new char[this.typeStack.size() + parts.length - 1][];
        int i = 0;
        for (ISourceElementRequestor.TypeInfo info : this.typeStack) {
            names[i++] = info.name.toCharArray();
        }
        int j = 0;
        while (j < parts.length - 1) {
            names[i++] = parts[j].toCharArray();
            ++j;
        }
        return names;
    }

    public void exitConstructor(int endOffset) {
    }

    public void exitField(int endOffset) {
    }

    public void exitMethod(int endOffset) {
    }

    public void exitScript(int endOffset) {
        this.typeStack.clear();
    }

    public void exitType(int endOffset) {
        this.typeStack.pop();
    }

    public void acceptMethodVisibilityChange(String methodName, int visibility) {
    }

    public void acceptModuleFunction(String function) {
    }

    public void acceptYield(String name) {
    }

    public void acceptBlock(int startOffset, int endOffset) {
    }
}

