/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.index.EntryResult;
import org.rubypeople.rdt.internal.core.index.Index;
import org.rubypeople.rdt.internal.core.search.IndexQueryRequestor;
import org.rubypeople.rdt.internal.core.search.RubySearchScope;

public abstract class InternalSearchPattern {
    IRubyElement focus;
    int kind;
    boolean mustResolve = true;

    void acceptMatch(String relativePath, String containerPath, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IRubySearchScope scope) {
        String documentPath;
        if (scope instanceof RubySearchScope ? !requestor.acceptIndexMatch(documentPath = this.documentPath(containerPath, relativePath), pattern, participant) : scope.encloses(documentPath = this.documentPath(containerPath, relativePath)) && !requestor.acceptIndexMatch(documentPath, pattern, participant)) {
            throw new OperationCanceledException();
        }
    }

    SearchPattern currentPattern() {
        return (SearchPattern)this;
    }

    String documentPath(String containerPath, String relativePath) {
        String separator = "/";
        StringBuffer buffer = new StringBuffer(containerPath.length() + separator.length() + relativePath.length());
        buffer.append(containerPath);
        buffer.append(separator);
        buffer.append(relativePath);
        return buffer.toString();
    }

    void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IRubySearchScope scope, IProgressMonitor monitor) throws IOException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            index.startQuery();
            SearchPattern pattern = this.currentPattern();
            EntryResult[] entries = pattern.queryIn(index);
            if (entries == null) {
                return;
            }
            SearchPattern decodedResult = pattern.getBlankPattern();
            String containerPath = index.containerPath;
            int i = 0;
            int l = entries.length;
            while (i < l) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                decodedResult.decodeIndexKey(entry.getWord());
                if (pattern.matchesDecodedKey(decodedResult)) {
                    String[] names = entry.getDocumentNames(index);
                    int j = 0;
                    int n = names.length;
                    while (j < n) {
                        this.acceptMatch(names[j], containerPath, decodedResult, requestor, participant, scope);
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            index.stopQuery();
        }
    }

    boolean isPolymorphicSearch() {
        return false;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        SearchPattern pattern = (SearchPattern)this;
        return index.query(pattern.getIndexCategories(), pattern.getIndexKey(), pattern.getMatchRule());
    }
}

