/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.FieldDeclarationMatch;
import org.rubypeople.rdt.core.search.FieldReferenceMatch;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.MethodDeclarationMatch;
import org.rubypeople.rdt.core.search.MethodReferenceMatch;
import org.rubypeople.rdt.core.search.SearchDocument;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.core.search.TypeDeclarationMatch;
import org.rubypeople.rdt.core.search.TypeReferenceMatch;
import org.rubypeople.rdt.internal.compiler.util.SimpleLookupTable;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderRoot;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.index.Index;
import org.rubypeople.rdt.internal.core.search.HandleFactory;
import org.rubypeople.rdt.internal.core.search.IndexQueryRequestor;
import org.rubypeople.rdt.internal.core.search.IndexSelector;
import org.rubypeople.rdt.internal.core.search.RubySearchDocument;
import org.rubypeople.rdt.internal.core.search.matching.InternalSearchPattern;
import org.rubypeople.rdt.internal.core.search.matching.PatternLocator;
import org.rubypeople.rdt.internal.core.search.matching.PossibleMatch;
import org.rubypeople.rdt.internal.core.search.matching.PossibleMatchSet;
import org.rubypeople.rdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchLocator {
    public static final int MAX_AT_ONCE;
    public SearchPattern pattern;
    public PatternLocator patternLocator;
    public int matchContainer;
    public SearchRequestor requestor;
    public IRubySearchScope scope;
    public IProgressMonitor progressMonitor;
    public IRubyScript[] workingCopies;
    public HandleFactory handleFactory;
    SimpleLookupTable bindings;
    int progressStep;
    int progressWorked;
    private PossibleMatch currentPossibleMatch;

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int ratio = (int)Math.round((double)maxMemory / 6.7108864E7);
        switch (ratio) {
            case 0: 
            case 1: {
                MAX_AT_ONCE = 100;
                break;
            }
            case 2: {
                MAX_AT_ONCE = 200;
                break;
            }
            case 3: {
                MAX_AT_ONCE = 300;
                break;
            }
            default: {
                MAX_AT_ONCE = 400;
            }
        }
    }

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IRubySearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.patternLocator = PatternLocator.patternLocator(this.pattern);
        this.matchContainer = this.patternLocator.matchContainer();
        this.requestor = requestor;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public static void findIndexMatches(InternalSearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IRubySearchScope scope, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, monitor);
    }

    public static IRubyElement getProjectOrJar(IRubyElement element) {
        while (!(element instanceof IRubyProject)) {
            element = element.getParent();
        }
        return element;
    }

    public static IRubyElement projectOrJarFocus(InternalSearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrJar(pattern.focus);
    }

    public static SearchDocument[] addWorkingCopies(InternalSearchPattern pattern, SearchDocument[] indexMatches, IRubyScript[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        HashMap workingCopyDocuments = MatchLocator.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == participant && (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        return matches;
    }

    public static void setFocus(InternalSearchPattern pattern, IRubyElement focus) {
        pattern.focus = focus;
    }

    private static HashMap workingCopiesThatCanSeeFocus(IRubyScript[] copies, IRubyElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IRubyProject) && !(focus instanceof ExternalSourceFolderRoot)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int i = 0;
        int length = copies.length;
        while (i < length) {
            IRubyScript workingCopy = copies[i];
            IPath projectOrJar = MatchLocator.getProjectOrJar(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant));
            }
            ++i;
        }
        return result;
    }

    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        int docsLength = searchDocuments.length;
        int n = docsLength < 1000 ? Math.min(Math.max(docsLength / 200 + 1, 2), 4) : 5 * (docsLength / 1000);
        this.progressStep = docsLength < n ? 1 : docsLength / n;
        this.progressWorked = 0;
        ArrayList<IRubyScript> copies = new ArrayList<IRubyScript>();
        int i = 0;
        while (i < docsLength) {
            SearchDocument document = searchDocuments[i];
            if (document instanceof WorkingCopyDocument) {
                copies.add(((WorkingCopyDocument)document).workingCopy);
            }
            ++i;
        }
        int copiesLength = copies.size();
        this.workingCopies = new IRubyScript[copiesLength];
        copies.toArray(this.workingCopies);
        RubyModelManager.getRubyModelManager();
        this.bindings = new SimpleLookupTable();
        try {
            if (this.handleFactory == null) {
                this.handleFactory = new HandleFactory();
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.beginTask("", searchDocuments.length);
            }
            RubyProject previousJavaProject = null;
            PossibleMatchSet matchSet = new PossibleMatchSet();
            Util.sort(searchDocuments, new Util.Comparer(){

                public int compare(Object a, Object b) {
                    return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                }
            });
            int displayed = 0;
            String previousPath = null;
            int i2 = 0;
            while (i2 < docsLength) {
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchDocument searchDocument = searchDocuments[i2];
                searchDocuments[i2] = null;
                String pathString = searchDocument.getPath();
                if (i2 > 0 && pathString.equals(previousPath)) {
                    if (this.progressMonitor != null) {
                        ++this.progressWorked;
                        if (this.progressWorked % this.progressStep == 0) {
                            this.progressMonitor.worked(this.progressStep);
                        }
                    }
                    ++displayed;
                } else {
                    Openable openable;
                    previousPath = pathString;
                    IRubyScript workingCopy = null;
                    if (searchDocument instanceof WorkingCopyDocument) {
                        workingCopy = ((WorkingCopyDocument)searchDocument).workingCopy;
                        openable = (Openable)((Object)workingCopy);
                    } else {
                        openable = this.handleFactory.createOpenable(pathString);
                    }
                    if (openable == null) {
                        if (this.progressMonitor != null) {
                            ++this.progressWorked;
                            if (this.progressWorked % this.progressStep == 0) {
                                this.progressMonitor.worked(this.progressStep);
                            }
                        }
                        ++displayed;
                    } else {
                        IResource resource = null;
                        RubyProject javaProject = (RubyProject)openable.getRubyProject();
                        IResource iResource = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                        if (resource == null) {
                            resource = javaProject.getProject();
                        }
                        if (!javaProject.equals(previousJavaProject)) {
                            if (previousJavaProject != null) {
                                try {
                                    this.locateMatches(previousJavaProject, matchSet, i2 - displayed);
                                    displayed = i2;
                                }
                                catch (RubyModelException rubyModelException) {}
                                matchSet.reset();
                            }
                            previousJavaProject = javaProject;
                        }
                        matchSet.add(new PossibleMatch(this, resource, openable, searchDocument, this.pattern.mustResolve));
                    }
                }
                ++i2;
            }
            if (previousJavaProject != null) {
                try {
                    this.locateMatches(previousJavaProject, matchSet, docsLength - displayed);
                }
                catch (RubyModelException rubyModelException) {}
            }
        }
        finally {
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
            this.bindings = null;
        }
    }

    protected boolean encloses(IRubyElement element) {
        return element != null && this.scope.encloses(element);
    }

    protected void report(SearchMatch match) throws CoreException {
        this.requestor.acceptSearchMatch(match);
    }

    protected void locateMatches(RubyProject javaProject, PossibleMatchSet matchSet, int expected) throws CoreException {
        PossibleMatch[] possibleMatches = matchSet.getPossibleMatches(javaProject.getSourceFolderRoots());
        int length = possibleMatches.length;
        if (this.progressMonitor != null && expected > length) {
            this.progressWorked += expected - length;
            this.progressMonitor.worked(expected - length);
        }
        int index = 0;
        while (index < length) {
            int max = Math.min(MAX_AT_ONCE, length - index);
            this.locateMatches(javaProject, possibleMatches, index, max);
            index += max;
        }
        this.patternLocator.clear();
    }

    protected void locateMatches(RubyProject rubyProject, PossibleMatch[] possibleMatches, int start, int length) throws CoreException {
        int i = start;
        int maxUnits = start + length;
        while (i < maxUnits) {
            PossibleMatch possibleMatch = possibleMatches[i];
            this.process(possibleMatch);
            possibleMatch.cleanUp();
            ++i;
        }
    }

    protected void process(PossibleMatch possibleMatch) {
        this.currentPossibleMatch = possibleMatch;
        RubyScript script = (RubyScript)possibleMatch.openable;
        this.patternLocator.reportMatches(script, this);
        this.currentPossibleMatch = null;
    }

    public SearchMatch newDeclarationMatch(IRubyElement element, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
        switch (element.getElementType()) {
            case 5: {
                return new TypeDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return new FieldDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 6: {
                return new MethodDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
        }
        return null;
    }

    public SearchMatch newDeclarationMatch(IRubyElement element, int accuracy, int offset, int length) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return this.newDeclarationMatch(element, accuracy, offset, length, participant, resource);
    }

    public SearchParticipant getParticipant() {
        return this.currentPossibleMatch.document.getParticipant();
    }

    public TypeReferenceMatch newTypeReferenceMatch(IRubyElement enclosingElement, int accuracy, int offset, int length) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new TypeReferenceMatch(enclosingElement, accuracy, offset, length, participant, resource);
    }

    public SearchMatch newFieldReferenceMatch(IRubyElement enclosingElement, IRubyElement binding, int accuracy, int offset, int length, Node reference) {
        boolean isReadAccess = false;
        boolean isWriteAccess = false;
        if (reference instanceof GlobalAsgnNode || reference instanceof ClassVarAsgnNode || reference instanceof InstAsgnNode) {
            isWriteAccess = true;
        } else {
            isReadAccess = true;
        }
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new FieldReferenceMatch(enclosingElement, binding, accuracy, offset, length, isReadAccess, isWriteAccess, false, participant, resource);
    }

    public SearchMatch newMethodReferenceMatch(IRubyElement enclosingElement, IRubyElement binding, List<String> arguments, int accuracy, int offset, int length, boolean isConstructor, Node reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new MethodReferenceMatch(enclosingElement, binding, arguments, accuracy, offset, length, isConstructor, false, participant, resource);
    }

    public static class WorkingCopyDocument
    extends RubySearchDocument {
        public IRubyScript workingCopy;

        WorkingCopyDocument(IRubyScript workingCopy, SearchParticipant participant) {
            super(workingCopy.getPath().toString(), participant);
            this.charContents = ((RubyScript)workingCopy).getContents();
            this.workingCopy = workingCopy;
        }

        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }
}

