/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import java.io.IOException;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.index.EntryResult;
import org.rubypeople.rdt.internal.core.index.Index;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.matching.RubySearchPattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class MethodPattern
extends RubySearchPattern
implements IIndexConstants {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] selector;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[][] parameterNames;
    public int parameterCount;
    public boolean varargs = false;
    protected IType declaringType;
    char[][] methodArguments;
    protected static char[][] REF_CATEGORIES = new char[][]{METHOD_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{METHOD_REF, METHOD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{METHOD_DECL};

    public static char[] createIndexKey(char[] selector, int argCount) {
        char[] countChars = argCount < 10 ? COUNTS[argCount] : ("/" + String.valueOf(argCount)).toCharArray();
        return CharOperation.concat(selector, countChars);
    }

    MethodPattern(int matchRule) {
        super(64, matchRule);
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, char[][] parameterNames, IType declaringType, int matchRule) {
        this(matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.selector = this.isCaseSensitive() || this.isCamelCase() ? selector : CharOperation.toLowerCase(selector);
        this.declaringQualification = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        char[] cArray = this.declaringSimpleName = this.isCaseSensitive() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        if (parameterNames != null) {
            this.parameterCount = parameterNames.length;
            this.parameterNames = new char[this.parameterCount][];
            int i = 0;
            while (i < this.parameterCount) {
                this.parameterNames[i] = this.isCaseSensitive() ? parameterNames[i] : CharOperation.toLowerCase(parameterNames[i]);
                ++i;
            }
        } else {
            this.parameterCount = -1;
        }
        this.declaringType = declaringType;
        this.mustResolve = this.mustResolve();
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, char[][] parameterNames, IMethod method, int matchRule) {
        this(findDeclarations, findReferences, selector, declaringQualification, declaringSimpleName, parameterNames, method.getDeclaringType(), matchRule);
        this.varargs = true;
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, char[][] parameterSimpleNames, int matchRule) {
        this(findDeclarations, findReferences, selector, declaringQualification, declaringSimpleName, parameterSimpleNames, (IType)null, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        int last = key.length - 1;
        this.parameterCount = 0;
        this.selector = null;
        int power = 1;
        int i = last;
        while (i >= 0) {
            if (key[i] == '/') {
                this.selector = new char[i];
                System.arraycopy(key, 0, this.selector, 0, i);
                break;
            }
            this.parameterCount = i == last ? key[i] - 48 : (this.parameterCount += (power *= 10) * (key[i] - 48));
            --i;
        }
    }

    public SearchPattern getBlankPattern() {
        return new MethodPattern(8);
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    boolean hasMethodArguments() {
        return this.methodArguments != null && this.methodArguments.length > 0;
    }

    boolean isPolymorphicSearch() {
        return this.findReferences;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        MethodPattern pattern = (MethodPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1 || this.varargs) && this.matchesName(this.selector, pattern.selector);
    }

    protected boolean mustResolve() {
        return this.declaringSimpleName != null || this.declaringQualification != null;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.selector;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                if (this.selector != null && this.parameterCount >= 0 && !this.varargs) {
                    key = MethodPattern.createIndexKey(this.selector, this.parameterCount);
                    break;
                }
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0 && !this.varargs) {
                    key = MethodPattern.createIndexKey(this.selector == null ? ONE_STAR : this.selector, this.parameterCount);
                    break;
                }
                if (this.selector == null || this.selector[this.selector.length - 1] == '*') break;
                key = CharOperation.concat(this.selector, ONE_STAR, '/');
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "MethodCombinedPattern: " : "MethodDeclarationPattern: ");
        } else {
            output.append("MethodReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            output.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            output.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            output.append("*.");
        }
        if (this.selector != null) {
            output.append(this.selector);
        } else {
            output.append("*");
        }
        output.append('(');
        if (this.parameterNames == null) {
            output.append("...");
        } else {
            int i = 0;
            int max = this.parameterNames.length;
            while (i < max) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.parameterNames[i] == null) {
                    output.append('*');
                } else {
                    output.append(this.parameterNames[i]);
                }
                ++i;
            }
        }
        output.append(')');
        return super.print(output);
    }
}

