/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;

public class RubySearchPattern
extends SearchPattern
implements IIndexConstants {
    boolean isCaseSensitive;
    boolean isCamelCase;
    int matchMode;
    int matchCompatibility;
    public static final int MATCH_MODE_MASK = 7;
    public static final int MATCH_COMPATIBILITY_MASK = 112;

    protected RubySearchPattern(int patternKind, int matchRule) {
        super(matchRule);
        this.kind = patternKind;
        int rule = this.getMatchRule();
        this.isCaseSensitive = (rule & 8) != 0;
        this.isCamelCase = (rule & 0x80) != 0;
        this.matchCompatibility = rule & 0x70;
        this.matchMode = rule & 7;
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    int getMatchMode() {
        return this.matchMode;
    }

    boolean isCamelCase() {
        return this.isCamelCase;
    }

    boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    protected StringBuffer print(StringBuffer output) {
        output.append(", ");
        if (this.isCamelCase) {
            output.append("camel case + ");
        }
        switch (this.getMatchMode()) {
            case 0: {
                output.append("exact match,");
                break;
            }
            case 1: {
                output.append("prefix match,");
                break;
            }
            case 2: {
                output.append("pattern match,");
                break;
            }
            case 4: {
                output.append("regexp match, ");
            }
        }
        if (this.isCaseSensitive()) {
            output.append(" case sensitive");
        } else {
            output.append(" case insensitive");
        }
        if ((this.matchCompatibility & 0x10) != 0) {
            output.append(", erasure only");
        }
        if ((this.matchCompatibility & 0x20) != 0) {
            output.append(", equivalent oronly");
        }
        return output;
    }
}

