/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASTUtil {
    private static final boolean VERBOSE = false;
    private static final String NAMESPACE_DELIMETER = "::";
    private static final String OBJECT = "Object";
    private static final String EMPTY_STRING = "";

    public static String[] getArgs(Node argsNode, StaticScope bodyNode) {
        if (argsNode == null) {
            return new String[0];
        }
        ArgsNode args = (ArgsNode)argsNode;
        boolean hasRest = false;
        if (args.getRestArg() != -1) {
            hasRest = true;
        }
        boolean hasBlock = false;
        if (args.getBlockArgNode() != null) {
            hasBlock = true;
        }
        int optArgCount = 0;
        if (args.getOptArgs() != null) {
            optArgCount = args.getOptArgs().size();
        }
        List<String> arguments = ASTUtil.getArguments(args.getArgs());
        if (optArgCount > 0) {
            arguments.addAll(ASTUtil.getArguments(args.getOptArgs()));
        }
        if (hasRest) {
            String restName = "*";
            if (args.getRestArg() != -2) {
                restName = String.valueOf(restName) + bodyNode.getVariables()[args.getRestArg()];
            }
            arguments.add(restName);
        }
        if (hasBlock) {
            arguments.add("&" + bodyNode.getVariables()[args.getBlockArgNode().getCount()]);
        }
        return ASTUtil.stringListToArray(arguments);
    }

    private static String[] stringListToArray(List<String> list) {
        String[] array = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    private static List<String> getArguments(ListNode argList) {
        if (argList == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (Object node : argList.childNodes()) {
            if (node instanceof ArgumentNode) {
                arguments.add(((ArgumentNode)node).getName());
                continue;
            }
            if (node instanceof LocalAsgnNode) {
                LocalAsgnNode local = (LocalAsgnNode)node;
                String argString = local.getName();
                argString = String.valueOf(argString) + " = ";
                argString = String.valueOf(argString) + ASTUtil.stringRepresentation(local.getValueNode());
                arguments.add(argString);
                continue;
            }
            System.err.println("Reached argument node type we can't handle");
        }
        return arguments;
    }

    public static String stringRepresentation(Node node) {
        if (node == null) {
            return EMPTY_STRING;
        }
        if (node instanceof HashNode) {
            return "{}";
        }
        if (node instanceof SelfNode) {
            return "self";
        }
        if (node instanceof NilNode) {
            return "nil";
        }
        if (node instanceof TrueNode) {
            return "true";
        }
        if (node instanceof FalseNode) {
            return "false";
        }
        if (node instanceof SymbolNode) {
            return String.valueOf(':') + ((SymbolNode)node).getName();
        }
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        if (node instanceof ZArrayNode) {
            return "[]";
        }
        if (node instanceof FixnumNode) {
            return EMPTY_STRING + ((FixnumNode)node).getValue();
        }
        if (node instanceof DStrNode) {
            return ASTUtil.stringRepresentation((DStrNode)node);
        }
        if (node instanceof StrNode) {
            return String.valueOf('\"') + ((StrNode)node).getValue().toString() + '\"';
        }
        ASTUtil.log("Reached node type we don't know how to represent: " + node.getClass().getName());
        return node.toString();
    }

    private static void log(String string) {
    }

    private static String stringRepresentation(DStrNode node) {
        List children = node.childNodes();
        StringBuffer buffer = new StringBuffer();
        buffer.append("\"");
        for (Node child : children) {
            buffer.append(ASTUtil.stringRepresentation(child));
        }
        buffer.append("\"");
        return buffer.toString();
    }

    public static String getNameReflectively(Node node) {
        if (node == null) {
            return EMPTY_STRING;
        }
        if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            return ASTUtil.getNameReflectively((Node)classNode.getCPath());
        }
        if (node instanceof ModuleNode) {
            ModuleNode moduleNode = (ModuleNode)node;
            return ASTUtil.getNameReflectively((Node)moduleNode.getCPath());
        }
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        try {
            Method getNameMethod = node.getClass().getMethod("getName", new Class[0]);
            Object name = getNameMethod.invoke((Object)node, new Object[0]);
            return (String)name;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFullyQualifiedName(Colon2Node node) {
        StringBuffer name = new StringBuffer();
        Node left = node.getLeftNode();
        if (left instanceof Colon2Node) {
            name.append(ASTUtil.getFullyQualifiedName((Colon2Node)left));
        } else if (left instanceof ConstNode) {
            name.append(((ConstNode)left).getName());
        }
        name.append(NAMESPACE_DELIMETER);
        name.append(node.getName());
        return name.toString();
    }

    public static boolean isAssignment(Node node) {
        return node instanceof LocalAsgnNode || node instanceof ClassVarAsgnNode || node instanceof InstAsgnNode || node instanceof GlobalAsgnNode || node instanceof AttrAssignNode;
    }

    public static String getSource(String contents, Node node) {
        if (node == null || contents == null) {
            return null;
        }
        ISourcePosition pos = node.getPosition();
        if (pos == null) {
            return null;
        }
        if (pos.getStartOffset() >= contents.length()) {
            return null;
        }
        if (pos.getEndOffset() > contents.length()) {
            return null;
        }
        return contents.substring(pos.getStartOffset(), pos.getEndOffset());
    }

    public static boolean isVariable(Node node) {
        return node instanceof GlobalAsgnNode || node instanceof GlobalVarNode || node instanceof InstAsgnNode || node instanceof InstVarNode || node instanceof ConstDeclNode || node instanceof ConstNode || node instanceof ClassVarAsgnNode || node instanceof ClassVarDeclNode || node instanceof ClassVarNode;
    }

    public static List<String> getArgumentsFromFunctionCall(IArgumentNode iVisited) {
        ArrayList<String> arguments = new ArrayList<String>();
        List<Node> nodes = ASTUtil.getArgumentNodesFromFunctionCall(iVisited);
        for (Node node : nodes) {
            if (node instanceof DAsgnNode) {
                DAsgnNode dasgn = (DAsgnNode)node;
                arguments.add(dasgn.getName());
                continue;
            }
            arguments.add(ASTUtil.stringRepresentation(node));
        }
        return arguments;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Node> getArgumentNodesFromFunctionCall(IArgumentNode iVisited) {
        arguments = new ArrayList<Node>();
        argsNode = iVisited.getArgsNode();
        iter = null;
        if (argsNode instanceof SplatNode) {
            splat = (SplatNode)argsNode;
            iter = splat.childNodes().iterator();
        } else if (argsNode instanceof ArrayNode) {
            arrayNode = (ArrayNode)iVisited.getArgsNode();
            iter = arrayNode.childNodes().iterator();
        } else if (argsNode == null) {
            iterNode = null;
            if (iVisited instanceof FCallNode) {
                fcall = (FCallNode)iVisited;
                iterNode = fcall.getIterNode();
            } else if (iVisited instanceof CallNode) {
                call = (CallNode)iVisited;
                iterNode = call.getIterNode();
            }
            if (iterNode == null) {
                return arguments;
            }
            if (iterNode instanceof IterNode) {
                yeah = (IterNode)iterNode;
                varNode = yeah.getVarNode();
                if (varNode instanceof DAsgnNode) {
                    dassgn = (DAsgnNode)varNode;
                    arguments.add((Node)dassgn);
                } else if (varNode instanceof MultipleAsgnNode) {
                    multi = (MultipleAsgnNode)varNode;
                    list = multi.getHeadNode();
                    if (list != null) {
                        iter = list.childNodes().iterator();
                    } else {
                        multiArgsNode = multi.getArgsNode();
                        if (multiArgsNode instanceof DAsgnNode) {
                            dassgn = (DAsgnNode)multiArgsNode;
                            arguments.add((Node)dassgn);
                        }
                    }
                }
            }
        }
        if (iter != null) ** GOTO lbl47
        return arguments;
lbl-1000:
        // 1 sources

        {
            argument = (Node)iter.next();
            arguments.add(argument);
lbl47:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl48:
        // 1 sources

        return arguments;
    }

    public static String getSuperClassName(Node superNode) {
        if (superNode == null) {
            return OBJECT;
        }
        return ASTUtil.getFullyQualifiedName(superNode);
    }

    public static String getFullyQualifiedName(Node node) {
        if (node == null) {
            return EMPTY_STRING;
        }
        if (node instanceof ConstNode) {
            ConstNode constNode = (ConstNode)node;
            return constNode.getName();
        }
        if (node instanceof Colon2Node) {
            Colon2Node colonNode = (Colon2Node)node;
            String prefix = ASTUtil.getFullyQualifiedName(colonNode.getLeftNode());
            if (prefix.length() > 0) {
                prefix = String.valueOf(prefix) + NAMESPACE_DELIMETER;
            }
            return String.valueOf(prefix) + colonNode.getName();
        }
        return ASTUtil.getNameReflectively(node);
    }

    public static String getFullyQualifiedTypeName(Node rootNode, Node typeNode) {
        return ASTUtil.getNamespace(rootNode, typeNode.getPosition().getStartOffset());
    }

    public static String getNamespace(Node root, int offset) {
        ArrayList<Node> surrounding = new ArrayList<Node>();
        Node typeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(root, offset, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ModuleNode || node instanceof ClassNode;
            }
        });
        if (typeNode == null) {
            return EMPTY_STRING;
        }
        if (offset < ((IScopingNode)typeNode).getCPath().getPosition().getEndOffset()) {
            typeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(root, typeNode.getPosition().getStartOffset() - 1, new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof ModuleNode || node instanceof ClassNode;
                }
            });
        }
        while (typeNode != null) {
            surrounding.add(0, typeNode);
            typeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(root, typeNode.getPosition().getStartOffset() - 1, new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof ModuleNode || node instanceof ClassNode;
                }
            });
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Node node : surrounding) {
            if (!first) {
                buffer.append(NAMESPACE_DELIMETER);
            }
            buffer.append(ASTUtil.getNameReflectively(node));
            if (!first) continue;
            first = false;
        }
        return buffer.toString();
    }

    public static String stringValue(Node node) {
        if (node instanceof StrNode) {
            return ((StrNode)node).getValue().toString();
        }
        if (node instanceof SymbolNode) {
            return ((SymbolNode)node).getName();
        }
        if (node instanceof FixnumNode) {
            return Long.toString(((FixnumNode)node).getValue());
        }
        if (node instanceof BignumNode) {
            return ((BignumNode)node).getValue().toString();
        }
        return null;
    }
}

