/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.util;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import org.jruby.CompatVersion;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.ParserSupport;
import org.jruby.parser.RubyParserResult;
import org.jruby.util.KCode;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.compiler.IScanner;
import org.rubypeople.rdt.core.compiler.InvalidInputException;

public class PublicScanner
implements IScanner {
    private char[] source;
    private RubyYaccLexer lexer = new RubyYaccLexer();
    private ParserSupport parserSupport = new ParserSupport();
    private RubyParserResult result;
    private LexerSource lexerSource;
    private int fOffset;
    private int fTokenLength;

    public PublicScanner() {
        ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, true, false, CompatVersion.RUBY1_8);
        this.parserSupport.setConfiguration(config);
        this.result = new RubyParserResult();
        this.parserSupport.setResult(this.result);
        this.lexer.setParserSupport(this.parserSupport);
        this.lexer.setWarnings((IRubyWarnings)new NullWarnings());
        this.lexer.setEncoding(config.getKCode().getEncoding());
    }

    public int getCurrentTokenEndPosition() {
        return this.fOffset + this.fTokenLength;
    }

    public int getCurrentTokenStartPosition() {
        return this.fTokenLength;
    }

    public int getNextToken() throws InvalidInputException {
        this.fOffset = this.lexerSource.getOffset();
        this.fTokenLength = 0;
        int returnValue = 0;
        boolean isEOF = false;
        try {
            boolean bl = isEOF = !this.lexer.advance();
            if (isEOF) {
                returnValue = -1;
            } else {
                this.fTokenLength = this.lexerSource.getOffset() - this.fOffset;
                returnValue = this.lexer.token();
            }
        }
        catch (SyntaxException syntaxException) {
            if (this.lexerSource.getOffset() == 0) {
                return -1;
            }
            this.fTokenLength = this.lexerSource.getOffset() - this.fOffset;
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            this.fTokenLength = this.lexerSource.getOffset() - this.fOffset;
            return returnValue;
        }
        catch (IOException e) {
            RubyCore.log(e);
        }
        return returnValue;
    }

    public void setSource(char[] source) {
        this.source = source;
        this.lexer.reset();
        this.lexer.setState(RubyYaccLexer.LexState.EXPR_BEG);
        this.parserSupport.initTopLocalVariables();
        ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, true, false, CompatVersion.RUBY1_8);
        this.lexerSource = LexerSource.getSource((String)"filename", (Reader)new CharArrayReader(source), null, (ParserConfiguration)config);
        this.lexer.setSource(this.lexerSource);
    }
}

