/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.YieldNode;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ti.BasicTypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeInferrer;
import org.rubypeople.rdt.internal.ti.TypeInferenceHelper;
import org.rubypeople.rdt.internal.ti.data.LiteralNodeTypeNames;
import org.rubypeople.rdt.internal.ti.data.TypicalMethodReturnNames;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.FirstPrecursorNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;
import org.rubypeople.rdt.internal.ti.util.ScopedNodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeInferrer
implements ITypeInferrer {
    private static final String CONSTRUCTOR_INVOKE_NAME = "new";
    private RootNode rootNode;
    private Set<Node> dontVisitNodes;
    private HashSet<Node> fVisitedNodes;
    private Map<String, RootNode> parsed;

    @Override
    public Collection<ITypeGuess> infer(String source, int offset) {
        this.dontVisitNodes = new HashSet<Node>();
        this.fVisitedNodes = new HashSet();
        this.parsed = new HashMap<String, RootNode>();
        try {
            this.rootNode = this.parse(source);
            Node node = OffsetNodeLocator.Instance().getNodeAtOffset(this.rootNode.getBodyNode(), offset);
            if (node == null) {
                ArrayList<ITypeGuess> arrayList = new ArrayList<ITypeGuess>();
                return arrayList;
            }
            Set<ITypeGuess> set = this.infer(node);
            return set;
        }
        catch (SyntaxException syntaxException) {
            ArrayList<ITypeGuess> arrayList = new ArrayList<ITypeGuess>();
            return arrayList;
        }
        finally {
            this.parsed.clear();
            this.dontVisitNodes.clear();
            this.fVisitedNodes.clear();
        }
    }

    private Set<ITypeGuess> infer(Node node) {
        ConstNode constNode;
        String name;
        if (this.fVisitedNodes.contains(node)) {
            return new HashSet<ITypeGuess>();
        }
        this.fVisitedNodes.add(node);
        HashSet<ITypeGuess> guesses = new HashSet<ITypeGuess>();
        this.tryLiteralNode(node, guesses);
        this.tryAsgnNode(node, guesses);
        this.tryDVarNode(node, guesses);
        this.tryLocalVarNode(node, guesses);
        this.tryInstVarNode(node, guesses);
        this.tryGlobalVarNode(node, guesses);
        this.tryMethodNode(node, guesses);
        this.tryIterNode(node, guesses);
        this.tryWellKnownMethodCalls(node, guesses);
        if (node instanceof Colon2Node) {
            Colon2Node colonNode = (Colon2Node)node;
            name = ASTUtil.getFullyQualifiedName(colonNode);
            guesses.add(new BasicTypeGuess(name, 100));
        }
        if (node instanceof ConstNode && !(name = (constNode = (ConstNode)node).getName()).equals("ARGV")) {
            guesses.add(new BasicTypeGuess(constNode.getName(), 100));
        }
        if (guesses.isEmpty() && node instanceof CallNode) {
            CallNode call = (CallNode)node;
            return this.infer(call.getReceiverNode());
        }
        return guesses;
    }

    private void tryDVarNode(Node node, Set<ITypeGuess> guesses) {
        if (!(node instanceof DVarNode)) {
            return;
        }
        Node iterNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)this.rootNode, node.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof IterNode;
            }
        });
        Node methodCall = OffsetNodeLocator.Instance().getNodeAtOffset((Node)this.rootNode, iterNode.getPosition().getStartOffset() - 1);
        try {
            SearchEngine engine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern(6, ASTUtil.getNameReflectively(methodCall), 0, 0);
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            IRubySearchScope scope = SearchEngine.createWorkspaceScope();
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            engine.search(pattern, participants, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
            List<SearchMatch> matches = requestor.getResults();
            for (SearchMatch match : matches) {
                IMethod method = (IMethod)match.getElement();
                String src = method.getRubyScript().getSource();
                RootNode otherRoot = this.parse(src);
                Node methodNodeThing = OffsetNodeLocator.Instance().getNodeAtOffset((Node)otherRoot, method.getSourceRange().getOffset());
                List<Node> yields = ScopedNodeLocator.Instance().findNodesInScope(methodNodeThing, new INodeAcceptor(){

                    public boolean doesAccept(Node node) {
                        return node instanceof YieldNode;
                    }
                });
                if (yields == null) continue;
                for (Node yield : yields) {
                    if (!(yield instanceof YieldNode)) continue;
                    YieldNode yieldNode = (YieldNode)yield;
                    Node argsNode = yieldNode.getArgsNode();
                    guesses.addAll(this.infer(src, argsNode.getPosition().getStartOffset()));
                }
            }
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    private RootNode parse(String src) {
        if (this.parsed.containsKey(src)) {
            return this.parsed.get(src);
        }
        RubyParser parser = new RubyParser();
        RootNode root = (RootNode)parser.parse(src).getAST();
        this.parsed.put(src, root);
        return root;
    }

    private void tryIterNode(Node node, Set<ITypeGuess> guesses) {
        if (!(node instanceof IterNode)) {
            return;
        }
        this.tryEnclosingType(node, guesses);
    }

    private void tryEnclosingType(Node node, Set<ITypeGuess> guesses) {
        Node typeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)this.rootNode, node.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ClassNode || node instanceof ModuleNode;
            }
        });
        if (typeNode == null) {
            guesses.add(new BasicTypeGuess("Object", 100));
        } else {
            guesses.add(new BasicTypeGuess(ASTUtil.getFullyQualifiedTypeName((Node)this.rootNode, typeNode), 100));
        }
    }

    private void tryMethodNode(Node node, Set<ITypeGuess> guesses) {
        if (!(node instanceof MethodDefNode)) {
            return;
        }
        this.tryEnclosingType(node, guesses);
    }

    private void tryLiteralNode(Node node, Collection<ITypeGuess> guesses) {
        String concreteGuess = LiteralNodeTypeNames.get(node.getClass().getSimpleName());
        if (concreteGuess != null) {
            guesses.add(new BasicTypeGuess(concreteGuess, 100));
        }
    }

    private void tryAsgnNode(Node node, Collection<ITypeGuess> guesses) {
        Node valueNode = null;
        if (node instanceof LocalAsgnNode) {
            valueNode = ((LocalAsgnNode)node).getValueNode();
        }
        if (node instanceof InstAsgnNode) {
            valueNode = ((InstAsgnNode)node).getValueNode();
        }
        if (node instanceof GlobalAsgnNode) {
            valueNode = ((GlobalAsgnNode)node).getValueNode();
        }
        if (valueNode != null) {
            guesses.addAll(this.infer(valueNode));
        }
    }

    private void tryInstVarNode(Node node, Collection<ITypeGuess> guesses) {
        if (!(node instanceof InstVarNode)) {
            return;
        }
        final InstVarNode instVarNode = (InstVarNode)node;
        Node assignmentNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)this.rootNode, instVarNode.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof InstAsgnNode;
            }
        });
        if (assignmentNode != null) {
            this.dontVisitNodes.add(assignmentNode);
        }
        ArrayList<Node> assignments = new ArrayList<Node>();
        assignments.addAll(ScopedNodeLocator.Instance().findNodesInScope((Node)this.rootNode, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof InstAsgnNode && ((InstAsgnNode)node).getName().equals(instVarNode.getName()) && !DefaultTypeInferrer.this.dontVisitNodes.contains(node);
            }
        }));
        for (Node assignNode : assignments) {
            this.tryAsgnNode(assignNode, guesses);
        }
    }

    private void tryGlobalVarNode(Node node, Collection<ITypeGuess> guesses) {
        if (!(node instanceof GlobalVarNode)) {
            return;
        }
        final GlobalVarNode globalVarNode = (GlobalVarNode)node;
        int nodeStart = node.getPosition().getStartOffset();
        Node initialAssignmentNode = FirstPrecursorNodeLocator.Instance().findFirstPrecursor((Node)this.rootNode, nodeStart, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                String name = null;
                if (node instanceof LocalAsgnNode) {
                    name = ((LocalAsgnNode)node).getName();
                }
                if (node instanceof InstAsgnNode) {
                    name = ((InstAsgnNode)node).getName();
                }
                if (node instanceof GlobalAsgnNode) {
                    name = ((GlobalAsgnNode)node).getName();
                }
                return name != null && name.equals(globalVarNode.getName());
            }
        });
        if (initialAssignmentNode != null) {
            this.tryAsgnNode(initialAssignmentNode, guesses);
        }
    }

    private void tryLocalVarNode(Node node, Collection<ITypeGuess> guesses) {
        Node defNode;
        ArgsNode argsNode;
        if (node instanceof VCallNode) {
            return;
        }
        if (!(node instanceof LocalVarNode)) {
            return;
        }
        LocalVarNode localVarNode = (LocalVarNode)node;
        int nodeStart = node.getPosition().getStartOffset();
        final String localVarName = TypeInferenceHelper.Instance().getVarName((Node)localVarNode);
        Node initialAssignmentNode = FirstPrecursorNodeLocator.Instance().findFirstPrecursor((Node)this.rootNode, nodeStart, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                String name = null;
                if (node instanceof LocalAsgnNode) {
                    name = ((LocalAsgnNode)node).getName();
                }
                if (node instanceof InstAsgnNode) {
                    name = ((InstAsgnNode)node).getName();
                }
                if (node instanceof GlobalAsgnNode) {
                    name = ((GlobalAsgnNode)node).getName();
                }
                return name != null && name.equals(localVarName);
            }
        });
        if (initialAssignmentNode != null) {
            this.tryAsgnNode(initialAssignmentNode, guesses);
        }
        if ((argsNode = (ArgsNode)FirstPrecursorNodeLocator.Instance().findFirstPrecursor((Node)this.rootNode, nodeStart, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ArgsNode && DefaultTypeInferrer.this.doesArgsNodeContainsVariable((ArgsNode)node, localVarName);
            }
        })) != null && (defNode = FirstPrecursorNodeLocator.Instance().findFirstPrecursor((Node)this.rootNode, nodeStart, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                ArgsNode argsNode = null;
                if (node instanceof DefnNode) {
                    argsNode = ((DefnNode)node).getArgsNode();
                }
                if (node instanceof DefsNode) {
                    argsNode = ((DefsNode)node).getArgsNode();
                }
                return argsNode != null && DefaultTypeInferrer.this.doesArgsNodeContainsVariable(argsNode, localVarName);
            }
        })) != null) {
            if (defNode instanceof DefnNode) {
                ((DefnNode)defNode).getName();
            }
            if (defNode instanceof DefsNode) {
                ((DefsNode)defNode).getName();
            }
        }
    }

    private void tryWellKnownMethodCalls(Node node, Collection<ITypeGuess> guesses) {
        if (!(node instanceof CallNode)) {
            return;
        }
        CallNode callNode = (CallNode)node;
        String method = callNode.getName();
        if (method.equals(CONSTRUCTOR_INVOKE_NAME)) {
            String name = null;
            if (callNode.getReceiverNode() instanceof ConstNode) {
                name = ((ConstNode)callNode.getReceiverNode()).getName();
            } else if (callNode.getReceiverNode() instanceof Colon2Node) {
                name = ASTUtil.getFullyQualifiedName((Colon2Node)callNode.getReceiverNode());
            }
            if (name != null) {
                guesses.add(new BasicTypeGuess(name, 100));
            }
        } else {
            String methodReturnTypeGuess = TypicalMethodReturnNames.get(method);
            if (methodReturnTypeGuess != null) {
                guesses.add(new BasicTypeGuess(methodReturnTypeGuess, 100));
            }
        }
    }

    private boolean doesArgsNodeContainsVariable(ArgsNode argsNode, String argName) {
        if (argsNode == null) {
            return false;
        }
        if (argName == null) {
            return false;
        }
        return this.getArgumentIndex(argsNode, argName) >= 0;
    }

    private int getArgumentIndex(ArgsNode argsNode, String argName) {
        int argNumber = 0;
        ListNode args = argsNode.getArgs();
        if (args == null) {
            return -1;
        }
        for (ArgumentNode arg : args.childNodes()) {
            if (arg.getName().equals(argName)) break;
            ++argNumber;
        }
        if (argNumber == argsNode.getRequiredArgsCount()) {
            return -1;
        }
        return argNumber;
    }
}

