/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti;

import java.util.Iterator;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.FCallNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;

public class TypeInferenceHelper {
    private static TypeInferenceHelper staticInstance = new TypeInferenceHelper();

    private TypeInferenceHelper() {
    }

    public static TypeInferenceHelper Instance() {
        return staticInstance;
    }

    public String getVarName(Node node) {
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        return null;
    }

    public int getArgIndex(ListNode listNode, String argName) {
        int argNumber = 0;
        Iterator iter = listNode.childNodes().iterator();
        while (iter.hasNext()) {
            if (((ArgumentNode)iter.next()).getName().equals(argName)) {
                return argNumber;
            }
            ++argNumber;
        }
        return -1;
    }

    public String getTypeNodeName(Node node) {
        if (node instanceof ClassNode) {
            return ((Colon2Node)((ClassNode)node).getCPath()).getName();
        }
        if (node instanceof ModuleNode) {
            return ((Colon2Node)((ModuleNode)node).getCPath()).getName();
        }
        return null;
    }

    public String getMethodDefinitionNodeName(Node methodNode) {
        if (methodNode instanceof MethodDefNode) {
            return ((MethodDefNode)methodNode).getName();
        }
        return null;
    }

    public boolean isArgumentInMethod(String varName, Node enclosingScopeNode) {
        ListNode listNode = this.getArgsListNode(enclosingScopeNode);
        if (listNode == null) {
            return false;
        }
        return this.getArgIndex(listNode, varName) >= 0;
    }

    public ListNode getArgsListNode(Node node) {
        if (node instanceof MethodDefNode) {
            return ((MethodDefNode)node).getArgsNode().getArgs();
        }
        if (node instanceof CallNode) {
            return ((ArgsNode)((CallNode)node).getArgsNode()).getArgs();
        }
        if (node instanceof FCallNode) {
            return (ArrayNode)((FCallNode)node).getArgsNode();
        }
        return null;
    }

    public String getCallNodeMethodName(Node node) {
        if (node instanceof CallNode) {
            return ((CallNode)node).getName();
        }
        if (node instanceof FCallNode) {
            return ((FCallNode)node).getName();
        }
        if (node instanceof VCallNode) {
            return ((VCallNode)node).getName();
        }
        return null;
    }

    public Node findNthArgExprInSendExpr(int n, Node sendExprNode) {
        ListNode listNode = this.getArgsListNode(sendExprNode);
        if (listNode == null) {
            return null;
        }
        return listNode.get(n);
    }
}

