/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti.util;

import java.util.LinkedList;
import java.util.List;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.ti.TypeInferenceHelper;
import org.rubypeople.rdt.internal.ti.util.NodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDefinitionLocator
extends NodeLocator {
    private static MethodDefinitionLocator staticInstance = new MethodDefinitionLocator();
    private TypeInferenceHelper helper = TypeInferenceHelper.Instance();
    private String typeName;
    private String methodName;
    private List<Node> locatedNodes;

    private MethodDefinitionLocator() {
    }

    public static MethodDefinitionLocator Instance() {
        return staticInstance;
    }

    public List<Node> findMethodDefinitions(Node rootNode, String typeName, String methodName) {
        if (rootNode == null) {
            return null;
        }
        this.locatedNodes = new LinkedList<Node>();
        this.typeNameStack = new LinkedList();
        this.typeName = typeName;
        this.methodName = methodName;
        this.typeNameStack.add("Kernel");
        rootNode.accept((NodeVisitor)this);
        return this.locatedNodes;
    }

    @Override
    public Instruction handleNode(Node iVisited) {
        String methodName;
        if ((iVisited instanceof DefnNode || iVisited instanceof DefsNode) && this.peekType().equals(this.typeName) && (methodName = this.helper.getMethodDefinitionNodeName(iVisited)).equals(methodName)) {
            this.locatedNodes.add(iVisited);
        }
        return super.handleNode(iVisited);
    }

    @Override
    public Instruction visitClassNode(ClassNode iVisited) {
        this.pushType(this.helper.getTypeNodeName((Node)iVisited));
        super.visitClassNode(iVisited);
        this.popType();
        return null;
    }

    @Override
    public Instruction visitModuleNode(ModuleNode iVisited) {
        this.pushType(this.helper.getTypeNodeName((Node)iVisited));
        super.visitModuleNode(iVisited);
        this.popType();
        return null;
    }
}

