/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti.util;

import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.ti.util.NodeLocator;

public class OffsetNodeLocator
extends NodeLocator {
    private static OffsetNodeLocator staticInstance = new OffsetNodeLocator();
    private Node locatedNode;
    private int offset;

    private OffsetNodeLocator() {
    }

    public static OffsetNodeLocator Instance() {
        return staticInstance;
    }

    public Node getNodeAtOffset(Node rootNode, int offset) {
        if (rootNode == null) {
            return null;
        }
        this.locatedNode = null;
        this.offset = offset;
        rootNode.accept((NodeVisitor)this);
        this.locatedNode = this.refine(this.locatedNode);
        return this.locatedNode;
    }

    private Node refine(Node node) {
        ArgsNode argsNode;
        if (node instanceof ArgsNode && (argsNode = (ArgsNode)node).getRequiredArgsCount() > 0) {
            for (ArgumentNode argNode : argsNode.getArgs().childNodes()) {
                if (!this.nodeDoesSpanOffset((Node)argNode, this.offset)) continue;
                return argNode;
            }
        }
        return node;
    }

    public Instruction handleNode(Node iVisited) {
        if (!(iVisited instanceof NewlineNode) && this.nodeDoesSpanOffset(iVisited, this.offset) && (this.locatedNode == null || this.nodeSpanLength(iVisited) <= this.nodeSpanLength(this.locatedNode))) {
            if (!(this.locatedNode instanceof Colon2Node) || !(iVisited instanceof ConstNode)) {
                this.locatedNode = iVisited;
            }
            if (iVisited instanceof ArgsNode) {
                ArgsNode args = (ArgsNode)iVisited;
                this.handleNode((Node)args.getRestArgNode());
            }
        }
        return super.handleNode(iVisited);
    }
}

