/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti.util;

import java.util.LinkedList;
import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.NodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedNodeLocator
extends NodeLocator {
    private static ScopedNodeLocator staticInstance = new ScopedNodeLocator();
    private INodeAcceptor acceptor;
    private List<Node> locatedNodes;

    private ScopedNodeLocator() {
    }

    public static ScopedNodeLocator Instance() {
        return staticInstance;
    }

    public List<Node> findNodesInScope(Node rootNode, INodeAcceptor acceptor) {
        if (rootNode == null) {
            return null;
        }
        if (acceptor == null) {
            return null;
        }
        this.locatedNodes = new LinkedList<Node>();
        this.acceptor = acceptor;
        rootNode.accept((NodeVisitor)this);
        return this.locatedNodes;
    }

    @Override
    public Instruction handleNode(Node iVisited) {
        if (this.acceptor.doesAccept(iVisited)) {
            this.locatedNodes.add(iVisited);
        }
        return super.handleNode(iVisited);
    }

    @Override
    public Instruction visitArgsNode(ArgsNode iVisited) {
        ArgumentNode argNode;
        if (iVisited.getRequiredArgsCount() > 0) {
            for (ArgumentNode argNode2 : iVisited.getArgs().childNodes()) {
                if (!this.acceptor.doesAccept((Node)argNode2)) continue;
                this.locatedNodes.add((Node)argNode2);
            }
        }
        if ((argNode = iVisited.getRestArgNode()) != null && this.acceptor.doesAccept((Node)argNode)) {
            ISourcePosition pos = argNode.getPosition();
            pos.adjustStartOffset(1);
            argNode.setPosition(pos);
            this.locatedNodes.add((Node)argNode);
        }
        return super.visitArgsNode(iVisited);
    }
}

