/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.refactoring;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.rubypeople.rdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.ViewerPane;
import org.rubypeople.rdt.ui.text.RubySourceViewerConfiguration;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class CreateTextFileChangePreviewViewer
implements IChangePreviewViewer {
    private ViewerPane fPane;
    private SourceViewer fSourceViewer;

    public void createControl(Composite parent) {
        this.fPane = new ViewerPane(parent, 0x800800);
        this.fSourceViewer = new SourceViewer((Composite)this.fPane, null, 66306);
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont"));
        this.fPane.setContent(this.fSourceViewer.getControl());
    }

    public Control getControl() {
        return this.fPane;
    }

    public void setInput(ChangePreviewViewerInput input) {
        Change change = input.getChange();
        if (!(change instanceof CreateTextFileChange)) {
            this.fSourceViewer.setInput(null);
            this.fPane.setText("");
            return;
        }
        CreateTextFileChange textFileChange = (CreateTextFileChange)change;
        this.fPane.setText(textFileChange.getName());
        Document document = new Document(textFileChange.getPreview());
        this.fSourceViewer.unconfigure();
        if ("ruby".equals(textFileChange.getTextType())) {
            RubyTextTools textTools = RubyPlugin.getDefault().getRubyTextTools();
            textTools.setupRubyDocumentPartitioner((IDocument)document);
            IPreferenceStore store = RubyPlugin.getDefault().getCombinedPreferenceStore();
            this.fSourceViewer.configure((SourceViewerConfiguration)new RubySourceViewerConfiguration(textTools.getColorManager(), store, null, null));
        } else {
            this.fSourceViewer.configure(new SourceViewerConfiguration());
        }
        this.fSourceViewer.setInput((Object)document);
    }

    public void refresh() {
        this.fSourceViewer.refresh();
    }
}

