/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.ui.refactoring.LanguageElementNode;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class RubyScriptChangeNode
extends TextEditChangeNode {
    static final TextEditChangeNode.ChildNode[] EMPTY_CHILDREN = new TextEditChangeNode.ChildNode[0];

    public RubyScriptChangeNode(TextEditBasedChange change) {
        super(change);
    }

    protected TextEditChangeNode.ChildNode[] createChildNodes() {
        TextEditBasedChange change = this.getTextEditBasedChange();
        IRubyScript cunit = (IRubyScript)change.getAdapter(IRubyScript.class);
        if (cunit != null) {
            ArrayList<TextEditChangeNode.ChildNode> children = new ArrayList<TextEditChangeNode.ChildNode>(5);
            HashMap map = new HashMap(20);
            TextEditBasedChangeGroup[] changes = this.getSortedChangeGroups(change);
            int i = 0;
            while (i < changes.length) {
                TextEditBasedChangeGroup tec = changes[i];
                try {
                    IRubyElement element = this.getModifiedRubyElement(tec, cunit);
                    if (element.equals(cunit)) {
                        children.add(RubyScriptChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                    } else {
                        RubyLanguageNode pjce = this.getChangeElement(map, element, children, this);
                        pjce.addChild(RubyScriptChangeNode.createTextEditGroupNode((TextEditChangeNode.ChildNode)pjce, (TextEditBasedChangeGroup)tec));
                    }
                }
                catch (RubyModelException rubyModelException) {
                    children.add(RubyScriptChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                }
                ++i;
            }
            return children.toArray(new TextEditChangeNode.ChildNode[children.size()]);
        }
        return EMPTY_CHILDREN;
    }

    private TextEditBasedChangeGroup[] getSortedChangeGroups(TextEditBasedChange change) {
        TextEditBasedChangeGroup[] edits = change.getChangeGroups();
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].getTextEditGroup().isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditBasedChangeGroup[result.size()]);
    }

    private IRubyElement getModifiedRubyElement(TextEditBasedChangeGroup edit, IRubyScript cunit) throws RubyModelException {
        IRegion range = edit.getRegion();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return cunit;
        }
        IRubyElement result = cunit.getElementAt(range.getOffset());
        if (result == null) {
            return cunit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getOffset(), ref.getSourceRange().getLength());
                if (result.getElementType() != 4 && result.getParent() != null && !this.coveredBy(edit, (IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (RubyModelException rubyModelException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private RubyLanguageNode getChangeElement(Map map, IRubyElement element, List children, TextEditChangeNode cunitChange) {
        RubyLanguageNode result = (RubyLanguageNode)((Object)map.get(element));
        if (result != null) {
            return result;
        }
        IRubyElement parent = element.getParent();
        if (parent instanceof IRubyScript) {
            result = new RubyLanguageNode(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            RubyLanguageNode parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new RubyLanguageNode((TextEditChangeNode.ChildNode)parentChange, element);
            parentChange.addChild((TextEditChangeNode.ChildNode)result);
            map.put(element, result);
        }
        return result;
    }

    private boolean coveredBy(TextEditBasedChangeGroup group, IRegion sourceRegion) {
        int sLength = sourceRegion.getLength();
        if (sLength == 0) {
            return false;
        }
        int sOffset = sourceRegion.getOffset();
        int sEnd = sOffset + sLength - 1;
        TextEdit[] edits = group.getTextEdits();
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = edits[i];
            if (edit.isDeleted()) {
                return false;
            }
            int rOffset = edit.getOffset();
            int rLength = edit.getLength();
            int rEnd = rOffset + rLength - 1;
            if (rLength == 0 ? sOffset >= rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class OffsetComparator
    implements Comparator {
        private OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextEditBasedChangeGroup c1 = (TextEditBasedChangeGroup)o1;
            TextEditBasedChangeGroup c2 = (TextEditBasedChangeGroup)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditBasedChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }

    private static class RubyLanguageNode
    extends LanguageElementNode {
        private IRubyElement fRubyElement;
        private static RubyElementImageProvider fgImageProvider = new RubyElementImageProvider();

        public RubyLanguageNode(TextEditChangeNode parent, IRubyElement element) {
            super(parent);
            this.fRubyElement = element;
            Assert.isNotNull((Object)this.fRubyElement);
        }

        public RubyLanguageNode(TextEditChangeNode.ChildNode parent, IRubyElement element) {
            super(parent);
            this.fRubyElement = element;
            Assert.isNotNull((Object)this.fRubyElement);
        }

        public String getText() {
            return RubyElementLabels.getElementLabel((IRubyElement)this.fRubyElement, (long)RubyElementLabels.ALL_DEFAULT);
        }

        public ImageDescriptor getImageDescriptor() {
            return fgImageProvider.getRubyImageDescriptor(this.fRubyElement, 3);
        }

        public IRegion getTextRange() throws CoreException {
            ISourceRange range = ((ISourceReference)this.fRubyElement).getSourceRange();
            return new Region(range.getOffset(), range.getLength());
        }
    }
}

