/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.Action;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.ui.RubyRefactoringWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringAction
extends Action {
    private Class<? extends RubyRefactoring> refactoringClass;
    private IRefactoringContext selectionProvider;
    private RubyRefactoring fRefactoring;

    public RefactoringAction(Class<? extends RubyRefactoring> refactoringClass, String refactoringName, IRefactoringContext selectionProvider) {
        this.setText(String.valueOf(refactoringName) + "...");
        this.refactoringClass = refactoringClass;
        this.selectionProvider = selectionProvider;
    }

    public void run() {
        try {
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true)) {
                RubyRefactoring refactoring = this.getRefactoring();
                RubyRefactoringWizard wizard = new RubyRefactoringWizard(refactoring);
                wizard.setWindowTitle(refactoring.getName());
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                op.run(shell, refactoring.getName());
            }
        }
        catch (Exception e) {
            RubyCore.log((Exception)e);
        }
    }

    private RubyRefactoring getRefactoring() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.fRefactoring != null) {
            return this.fRefactoring;
        }
        Constructor<?> constructor = this.refactoringClass.getConstructors()[0];
        Object[] args = constructor.getParameterTypes().length == 1 ? new Object[]{this.selectionProvider} : new Object[]{};
        this.fRefactoring = (RubyRefactoring)((Object)constructor.newInstance(args));
        return this.fRefactoring;
    }
}

