/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.classnodeprovider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;

public class IncludedClassesProvider
extends ClassNodeProvider {
    private String includingFileName;
    private ArrayList<IPath> includeFilePaths;

    public IncludedClassesProvider(IDocumentProvider documentProvider) {
        super(documentProvider);
        this.includingFileName = documentProvider.getActiveFileName();
        this.prepareIncludedFileNames();
        this.addIncludedFiles();
    }

    public String getIncludingFileName() {
        return this.includingFileName;
    }

    public String getIncludingFileDocument() {
        return this.documentProvider.getActiveFileContent();
    }

    private void prepareIncludedFileNames() {
        this.includeFilePaths = new ArrayList();
        RootNode rootNode = this.documentProvider.getActiveFileRootNode();
        Collection<FCallNode> loadAndRequireNodes = NodeProvider.getLoadAndRequireNodes((Node)rootNode);
        for (FCallNode fCallNode : loadAndRequireNodes) {
            this.addToIncludeFiles(fCallNode.getArgsNode());
        }
    }

    private void addToIncludeFiles(Node node) {
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            for (Object o : arrayNode.childNodes()) {
                if (!(o instanceof StrNode)) continue;
                StrNode strNode = (StrNode)o;
                this.appendPath(strNode.getValue().toString());
            }
        }
    }

    private void appendPath(String pathName) {
        Path path = new Path(pathName);
        if (path.getFileExtension() == null) {
            path = path.addFileExtension("rb");
        }
        if (!path.getFileExtension().equalsIgnoreCase("rb")) {
            path = path.addFileExtension("rb");
        }
        this.includeFilePaths.add((IPath)path);
    }

    private void addIncludedFiles() {
        for (IPath currentPath : this.includeFilePaths) {
            String currentFileName = currentPath.toOSString();
            super.addSource(currentFileName);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }
}

