/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.refactoring.core.IRefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.Messages;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefactoringConditionChecker
implements IRefactoringConditionChecker {
    private Map<String, Collection<String>> messages;
    private IDocumentProvider docProvider;
    private final IRefactoringConfig config;

    public RefactoringConditionChecker(IRefactoringConfig config) {
        this.docProvider = config.getDocumentProvider();
        this.config = config;
        this.initMessages();
        this.addLocalInitialErrors();
        if (this.shouldPerform(true)) {
            this.init(config);
        }
    }

    public boolean shouldPerform(boolean onlyInternalErrors) {
        if (!onlyInternalErrors && this.shouldPerform(true)) {
            this.checkInitialConditions();
        }
        return this.messages.get("errors").isEmpty();
    }

    @Override
    public boolean shouldPerform() {
        return this.shouldPerform(false);
    }

    @Override
    public Map<String, Collection<String>> getFinalMessages() {
        this.initMessages();
        this.checkFinalConditions();
        this.checkForSyntaxErrors();
        return this.messages;
    }

    private void checkForSyntaxErrors() {
        boolean syntaxError = false;
        for (String file : this.docProvider.getFileNames()) {
            if (!NodeProvider.hasSyntaxErrors(file, this.docProvider.getFileContent(file))) continue;
            syntaxError = true;
        }
        if (syntaxError) {
            this.addWarning(Messages.RefactoringConditionChecker_SyntaxErrorInProject);
        }
    }

    private void initMessages() {
        this.messages = new LinkedHashMap<String, Collection<String>>();
        this.messages.put("errors", new ArrayList());
        this.messages.put("warnings", new ArrayList());
    }

    @Override
    public Map<String, Collection<String>> getInitialMessages() {
        this.initMessages();
        this.addInitialMessages();
        return this.messages;
    }

    private void addInitialMessages() {
        this.addLocalInitialErrors();
        if (this.shouldPerform(true)) {
            this.checkInitialConditions();
        }
    }

    private void addLocalInitialErrors() {
        block5: {
            String fileName = null;
            try {
                fileName = this.docProvider.getActiveFileName();
                if (this.docProvider.getActiveFileContent().equals("")) {
                    this.addError(Messages.RefactoringConditionChecker_EmptyDocument);
                }
                Iterator<String> iterator = this.docProvider.getFileNames().iterator();
                while (iterator.hasNext()) {
                    String aktFileName;
                    fileName = aktFileName = iterator.next();
                    this.docProvider.getRootNode(aktFileName);
                }
            }
            catch (SyntaxException syntaxException) {
                String activeFileName = this.docProvider.getActiveFileName();
                if (fileName != null && !fileName.equals(activeFileName)) break block5;
                this.addError(Messages.RefactoringConditionChecker_SyntaxErrorInCurrent);
            }
        }
        if (NodeProvider.hasSyntaxErrors(this.docProvider.getActiveFileName(), this.docProvider.getActiveFileContent())) {
            this.addError(Messages.RefactoringConditionChecker_SyntaxErrorInCurrent);
        }
    }

    protected void addError(String message) {
        this.messages.get("errors").add(message);
    }

    protected void addWarning(String message) {
        this.messages.get("warnings").add(message);
    }

    protected boolean hasErrors() {
        return !this.messages.get("errors").isEmpty();
    }

    protected abstract void checkInitialConditions();

    protected void checkFinalConditions() {
    }

    public abstract void init(IRefactoringConfig var1);

    public IRefactoringConfig getConfig() {
        return this.config;
    }
}

